@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.machinelearningservices.kotlin.inputs

import com.pulumi.azurenative.machinelearningservices.inputs.AmlTokenArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * AML Token identity configuration.
 * @property identityType Enum to determine identity framework.
 * Expected value is 'AMLToken'.
 */
public data class AmlTokenArgs(
    public val identityType: Output<String>,
) : ConvertibleToJava<com.pulumi.azurenative.machinelearningservices.inputs.AmlTokenArgs> {
    override fun toJava(): com.pulumi.azurenative.machinelearningservices.inputs.AmlTokenArgs =
        com.pulumi.azurenative.machinelearningservices.inputs.AmlTokenArgs.builder()
            .identityType(identityType.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [AmlTokenArgs].
 */
@PulumiTagMarker
public class AmlTokenArgsBuilder internal constructor() {
    private var identityType: Output<String>? = null

    /**
     * @param value Enum to determine identity framework.
     * Expected value is 'AMLToken'.
     */
    @JvmName("dqxgcvuwqahurdju")
    public suspend fun identityType(`value`: Output<String>) {
        this.identityType = value
    }

    /**
     * @param value Enum to determine identity framework.
     * Expected value is 'AMLToken'.
     */
    @JvmName("ceebbxmibrhyldsv")
    public suspend fun identityType(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.identityType = mapped
    }

    internal fun build(): AmlTokenArgs = AmlTokenArgs(
        identityType = identityType ?: throw PulumiNullFieldException("identityType"),
    )
}
