@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.machinelearningservices.kotlin.inputs

import com.pulumi.azurenative.machinelearningservices.inputs.AutoDeleteSettingArgs.builder
import com.pulumi.azurenative.machinelearningservices.kotlin.enums.AutoDeleteCondition
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property condition When to check if an asset is expired
 * @property value Expiration condition value.
 */
public data class AutoDeleteSettingArgs(
    public val condition: Output<Either<String, AutoDeleteCondition>>? = null,
    public val `value`: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.machinelearningservices.inputs.AutoDeleteSettingArgs> {
    override fun toJava(): com.pulumi.azurenative.machinelearningservices.inputs.AutoDeleteSettingArgs =
        com.pulumi.azurenative.machinelearningservices.inputs.AutoDeleteSettingArgs.builder()
            .condition(
                condition?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .`value`(`value`?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [AutoDeleteSettingArgs].
 */
@PulumiTagMarker
public class AutoDeleteSettingArgsBuilder internal constructor() {
    private var condition: Output<Either<String, AutoDeleteCondition>>? = null

    private var `value`: Output<String>? = null

    /**
     * @param value When to check if an asset is expired
     */
    @JvmName("qjmjsahnoljkilxm")
    public suspend fun condition(`value`: Output<Either<String, AutoDeleteCondition>>) {
        this.condition = value
    }

    /**
     * @param value Expiration condition value.
     */
    @JvmName("csgyyguwiwkldudi")
    public suspend fun `value`(`value`: Output<String>) {
        this.`value` = value
    }

    /**
     * @param value When to check if an asset is expired
     */
    @JvmName("xortqvukkobmklbb")
    public suspend fun condition(`value`: Either<String, AutoDeleteCondition>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.condition = mapped
    }

    /**
     * @param value When to check if an asset is expired
     */
    @JvmName("pmwliautjjyrgeox")
    public fun condition(`value`: String) {
        val toBeMapped = Either.ofLeft<String, AutoDeleteCondition>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.condition = mapped
    }

    /**
     * @param value When to check if an asset is expired
     */
    @JvmName("wugqwhjcbxndbvfg")
    public fun condition(`value`: AutoDeleteCondition) {
        val toBeMapped = Either.ofRight<String, AutoDeleteCondition>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.condition = mapped
    }

    /**
     * @param value Expiration condition value.
     */
    @JvmName("uqwyrxjrfasfsbrj")
    public suspend fun `value`(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.`value` = mapped
    }

    internal fun build(): AutoDeleteSettingArgs = AutoDeleteSettingArgs(
        condition = condition,
        `value` = `value`,
    )
}
