@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.machinelearningservices.kotlin.inputs

import com.pulumi.azurenative.machinelearningservices.inputs.AutoForecastHorizonArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Forecast horizon determined automatically by system.
 * @property mode Enum to determine forecast horizon selection mode.
 * Expected value is 'Auto'.
 */
public data class AutoForecastHorizonArgs(
    public val mode: Output<String>,
) : ConvertibleToJava<com.pulumi.azurenative.machinelearningservices.inputs.AutoForecastHorizonArgs> {
    override fun toJava():
        com.pulumi.azurenative.machinelearningservices.inputs.AutoForecastHorizonArgs =
        com.pulumi.azurenative.machinelearningservices.inputs.AutoForecastHorizonArgs.builder()
            .mode(mode.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [AutoForecastHorizonArgs].
 */
@PulumiTagMarker
public class AutoForecastHorizonArgsBuilder internal constructor() {
    private var mode: Output<String>? = null

    /**
     * @param value Enum to determine forecast horizon selection mode.
     * Expected value is 'Auto'.
     */
    @JvmName("vnomepecdkepikqh")
    public suspend fun mode(`value`: Output<String>) {
        this.mode = value
    }

    /**
     * @param value Enum to determine forecast horizon selection mode.
     * Expected value is 'Auto'.
     */
    @JvmName("wdrlxcfxgqdvpmct")
    public suspend fun mode(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.mode = mapped
    }

    internal fun build(): AutoForecastHorizonArgs = AutoForecastHorizonArgs(
        mode = mode ?: throw PulumiNullFieldException("mode"),
    )
}
