@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.machinelearningservices.kotlin.inputs

import com.pulumi.azurenative.machinelearningservices.inputs.AutoPausePropertiesArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.Int
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Auto pause properties
 * @property delayInMinutes
 * @property enabled
 */
public data class AutoPausePropertiesArgs(
    public val delayInMinutes: Output<Int>? = null,
    public val enabled: Output<Boolean>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.machinelearningservices.inputs.AutoPausePropertiesArgs> {
    override fun toJava():
        com.pulumi.azurenative.machinelearningservices.inputs.AutoPausePropertiesArgs =
        com.pulumi.azurenative.machinelearningservices.inputs.AutoPausePropertiesArgs.builder()
            .delayInMinutes(delayInMinutes?.applyValue({ args0 -> args0 }))
            .enabled(enabled?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [AutoPausePropertiesArgs].
 */
@PulumiTagMarker
public class AutoPausePropertiesArgsBuilder internal constructor() {
    private var delayInMinutes: Output<Int>? = null

    private var enabled: Output<Boolean>? = null

    /**
     * @param value
     */
    @JvmName("ghaoiioqfufawmqo")
    public suspend fun delayInMinutes(`value`: Output<Int>) {
        this.delayInMinutes = value
    }

    /**
     * @param value
     */
    @JvmName("brryvhollvdycnet")
    public suspend fun enabled(`value`: Output<Boolean>) {
        this.enabled = value
    }

    /**
     * @param value
     */
    @JvmName("mqmvjgokiejylhra")
    public suspend fun delayInMinutes(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.delayInMinutes = mapped
    }

    /**
     * @param value
     */
    @JvmName("shtatgmsanfdfcbf")
    public suspend fun enabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enabled = mapped
    }

    internal fun build(): AutoPausePropertiesArgs = AutoPausePropertiesArgs(
        delayInMinutes = delayInMinutes,
        enabled = enabled,
    )
}
