@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.machinelearningservices.kotlin.inputs

import com.pulumi.azurenative.machinelearningservices.inputs.ClassificationArgs.builder
import com.pulumi.azurenative.machinelearningservices.kotlin.enums.ClassificationPrimaryMetrics
import com.pulumi.azurenative.machinelearningservices.kotlin.enums.LogVerbosity
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Double
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Classification task in AutoML Table vertical.
 * @property cvSplitColumnNames Columns to use for CVSplit data.
 * @property featurizationSettings Featurization inputs needed for AutoML job.
 * @property limitSettings Execution constraints for AutoMLJob.
 * @property logVerbosity Log verbosity for the job.
 * @property nCrossValidations Number of cross validation folds to be applied on training dataset
 * when validation dataset is not provided.
 * @property positiveLabel Positive label for binary metrics calculation.
 * @property primaryMetric Primary metric for the task.
 * @property targetColumnName Target column name: This is prediction values column.
 * Also known as label column name in context of classification tasks.
 * @property taskType AutoMLJob Task type.
 * Expected value is 'Classification'.
 * @property testData Test data input.
 * @property testDataSize The fraction of test dataset that needs to be set aside for validation purpose.
 * Values between (0.0 , 1.0)
 * Applied when validation dataset is not provided.
 * @property trainingData [Required] Training data input.
 * @property trainingSettings Inputs for training phase for an AutoML Job.
 * @property validationData Validation data inputs.
 * @property validationDataSize The fraction of training dataset that needs to be set aside for validation purpose.
 * Values between (0.0 , 1.0)
 * Applied when validation dataset is not provided.
 * @property weightColumnName The name of the sample weight column. Automated ML supports a weighted column as an input, causing rows in the data to be weighted up or down.
 */
public data class ClassificationArgs(
    public val cvSplitColumnNames: Output<List<String>>? = null,
    public val featurizationSettings: Output<TableVerticalFeaturizationSettingsArgs>? = null,
    public val limitSettings: Output<TableVerticalLimitSettingsArgs>? = null,
    public val logVerbosity: Output<Either<String, LogVerbosity>>? = null,
    public val nCrossValidations:
    Output<Either<AutoNCrossValidationsArgs, CustomNCrossValidationsArgs>>? = null,
    public val positiveLabel: Output<String>? = null,
    public val primaryMetric: Output<Either<String, ClassificationPrimaryMetrics>>? = null,
    public val targetColumnName: Output<String>? = null,
    public val taskType: Output<String>,
    public val testData: Output<MLTableJobInputArgs>? = null,
    public val testDataSize: Output<Double>? = null,
    public val trainingData: Output<MLTableJobInputArgs>,
    public val trainingSettings: Output<ClassificationTrainingSettingsArgs>? = null,
    public val validationData: Output<MLTableJobInputArgs>? = null,
    public val validationDataSize: Output<Double>? = null,
    public val weightColumnName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.machinelearningservices.inputs.ClassificationArgs> {
    override fun toJava(): com.pulumi.azurenative.machinelearningservices.inputs.ClassificationArgs =
        com.pulumi.azurenative.machinelearningservices.inputs.ClassificationArgs.builder()
            .cvSplitColumnNames(cvSplitColumnNames?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .featurizationSettings(
                featurizationSettings?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .limitSettings(limitSettings?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .logVerbosity(
                logVerbosity?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .nCrossValidations(
                nCrossValidations?.applyValue({ args0 ->
                    args0.transform({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    }, { args0 -> args0.let({ args0 -> args0.toJava() }) })
                }),
            )
            .positiveLabel(positiveLabel?.applyValue({ args0 -> args0 }))
            .primaryMetric(
                primaryMetric?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .targetColumnName(targetColumnName?.applyValue({ args0 -> args0 }))
            .taskType(taskType.applyValue({ args0 -> args0 }))
            .testData(testData?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .testDataSize(testDataSize?.applyValue({ args0 -> args0 }))
            .trainingData(trainingData.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .trainingSettings(trainingSettings?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .validationData(validationData?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .validationDataSize(validationDataSize?.applyValue({ args0 -> args0 }))
            .weightColumnName(weightColumnName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ClassificationArgs].
 */
@PulumiTagMarker
public class ClassificationArgsBuilder internal constructor() {
    private var cvSplitColumnNames: Output<List<String>>? = null

    private var featurizationSettings: Output<TableVerticalFeaturizationSettingsArgs>? = null

    private var limitSettings: Output<TableVerticalLimitSettingsArgs>? = null

    private var logVerbosity: Output<Either<String, LogVerbosity>>? = null

    private var nCrossValidations:
        Output<Either<AutoNCrossValidationsArgs, CustomNCrossValidationsArgs>>? = null

    private var positiveLabel: Output<String>? = null

    private var primaryMetric: Output<Either<String, ClassificationPrimaryMetrics>>? = null

    private var targetColumnName: Output<String>? = null

    private var taskType: Output<String>? = null

    private var testData: Output<MLTableJobInputArgs>? = null

    private var testDataSize: Output<Double>? = null

    private var trainingData: Output<MLTableJobInputArgs>? = null

    private var trainingSettings: Output<ClassificationTrainingSettingsArgs>? = null

    private var validationData: Output<MLTableJobInputArgs>? = null

    private var validationDataSize: Output<Double>? = null

    private var weightColumnName: Output<String>? = null

    /**
     * @param value Columns to use for CVSplit data.
     */
    @JvmName("nbucrxkaithyxsjl")
    public suspend fun cvSplitColumnNames(`value`: Output<List<String>>) {
        this.cvSplitColumnNames = value
    }

    @JvmName("lwuissiwvaqtakti")
    public suspend fun cvSplitColumnNames(vararg values: Output<String>) {
        this.cvSplitColumnNames = Output.all(values.asList())
    }

    /**
     * @param values Columns to use for CVSplit data.
     */
    @JvmName("bfnigqgjrqwgxmps")
    public suspend fun cvSplitColumnNames(values: List<Output<String>>) {
        this.cvSplitColumnNames = Output.all(values)
    }

    /**
     * @param value Featurization inputs needed for AutoML job.
     */
    @JvmName("eiprsiwvwoyaxuvp")
    public suspend
    fun featurizationSettings(`value`: Output<TableVerticalFeaturizationSettingsArgs>) {
        this.featurizationSettings = value
    }

    /**
     * @param value Execution constraints for AutoMLJob.
     */
    @JvmName("sagacxcujpuqdkxj")
    public suspend fun limitSettings(`value`: Output<TableVerticalLimitSettingsArgs>) {
        this.limitSettings = value
    }

    /**
     * @param value Log verbosity for the job.
     */
    @JvmName("tlqmqcxjmuidtcsy")
    public suspend fun logVerbosity(`value`: Output<Either<String, LogVerbosity>>) {
        this.logVerbosity = value
    }

    /**
     * @param value Number of cross validation folds to be applied on training dataset
     * when validation dataset is not provided.
     */
    @JvmName("oldnmouwbgnnnqut")
    public suspend
    fun nCrossValidations(`value`: Output<Either<AutoNCrossValidationsArgs, CustomNCrossValidationsArgs>>) {
        this.nCrossValidations = value
    }

    /**
     * @param value Positive label for binary metrics calculation.
     */
    @JvmName("fewncvpinywjxmgs")
    public suspend fun positiveLabel(`value`: Output<String>) {
        this.positiveLabel = value
    }

    /**
     * @param value Primary metric for the task.
     */
    @JvmName("oxaophpotfksesgx")
    public suspend fun primaryMetric(`value`: Output<Either<String, ClassificationPrimaryMetrics>>) {
        this.primaryMetric = value
    }

    /**
     * @param value Target column name: This is prediction values column.
     * Also known as label column name in context of classification tasks.
     */
    @JvmName("vtorlypvcxmeihla")
    public suspend fun targetColumnName(`value`: Output<String>) {
        this.targetColumnName = value
    }

    /**
     * @param value AutoMLJob Task type.
     * Expected value is 'Classification'.
     */
    @JvmName("qwhmbvpsxuoyvlup")
    public suspend fun taskType(`value`: Output<String>) {
        this.taskType = value
    }

    /**
     * @param value Test data input.
     */
    @JvmName("kyhosrbpgtsyvywr")
    public suspend fun testData(`value`: Output<MLTableJobInputArgs>) {
        this.testData = value
    }

    /**
     * @param value The fraction of test dataset that needs to be set aside for validation purpose.
     * Values between (0.0 , 1.0)
     * Applied when validation dataset is not provided.
     */
    @JvmName("philkcyioykcnocs")
    public suspend fun testDataSize(`value`: Output<Double>) {
        this.testDataSize = value
    }

    /**
     * @param value [Required] Training data input.
     */
    @JvmName("upmxxqpixvctcefe")
    public suspend fun trainingData(`value`: Output<MLTableJobInputArgs>) {
        this.trainingData = value
    }

    /**
     * @param value Inputs for training phase for an AutoML Job.
     */
    @JvmName("yynircxqdgcrfspu")
    public suspend fun trainingSettings(`value`: Output<ClassificationTrainingSettingsArgs>) {
        this.trainingSettings = value
    }

    /**
     * @param value Validation data inputs.
     */
    @JvmName("verjkjbbthglwwqr")
    public suspend fun validationData(`value`: Output<MLTableJobInputArgs>) {
        this.validationData = value
    }

    /**
     * @param value The fraction of training dataset that needs to be set aside for validation purpose.
     * Values between (0.0 , 1.0)
     * Applied when validation dataset is not provided.
     */
    @JvmName("tqxcxmirpktuwpow")
    public suspend fun validationDataSize(`value`: Output<Double>) {
        this.validationDataSize = value
    }

    /**
     * @param value The name of the sample weight column. Automated ML supports a weighted column as an input, causing rows in the data to be weighted up or down.
     */
    @JvmName("kojgnhkksimeangw")
    public suspend fun weightColumnName(`value`: Output<String>) {
        this.weightColumnName = value
    }

    /**
     * @param value Columns to use for CVSplit data.
     */
    @JvmName("wsafjmwqualteotf")
    public suspend fun cvSplitColumnNames(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.cvSplitColumnNames = mapped
    }

    /**
     * @param values Columns to use for CVSplit data.
     */
    @JvmName("vctaxknonyftayks")
    public suspend fun cvSplitColumnNames(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.cvSplitColumnNames = mapped
    }

    /**
     * @param value Featurization inputs needed for AutoML job.
     */
    @JvmName("oabfvfkfnhdyeqmq")
    public suspend fun featurizationSettings(`value`: TableVerticalFeaturizationSettingsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.featurizationSettings = mapped
    }

    /**
     * @param argument Featurization inputs needed for AutoML job.
     */
    @JvmName("rkexubmimafkjdkk")
    public suspend
    fun featurizationSettings(argument: suspend TableVerticalFeaturizationSettingsArgsBuilder.() -> Unit) {
        val toBeMapped = TableVerticalFeaturizationSettingsArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.featurizationSettings = mapped
    }

    /**
     * @param value Execution constraints for AutoMLJob.
     */
    @JvmName("dtmhiursxskqpidv")
    public suspend fun limitSettings(`value`: TableVerticalLimitSettingsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.limitSettings = mapped
    }

    /**
     * @param argument Execution constraints for AutoMLJob.
     */
    @JvmName("fxaoiflgfgnfynbd")
    public suspend
    fun limitSettings(argument: suspend TableVerticalLimitSettingsArgsBuilder.() -> Unit) {
        val toBeMapped = TableVerticalLimitSettingsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.limitSettings = mapped
    }

    /**
     * @param value Log verbosity for the job.
     */
    @JvmName("jcfmsqwayjpibikw")
    public suspend fun logVerbosity(`value`: Either<String, LogVerbosity>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.logVerbosity = mapped
    }

    /**
     * @param value Log verbosity for the job.
     */
    @JvmName("ibevasdfeewngmbv")
    public fun logVerbosity(`value`: String) {
        val toBeMapped = Either.ofLeft<String, LogVerbosity>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.logVerbosity = mapped
    }

    /**
     * @param value Log verbosity for the job.
     */
    @JvmName("veiadcxyborwilvt")
    public fun logVerbosity(`value`: LogVerbosity) {
        val toBeMapped = Either.ofRight<String, LogVerbosity>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.logVerbosity = mapped
    }

    /**
     * @param value Number of cross validation folds to be applied on training dataset
     * when validation dataset is not provided.
     */
    @JvmName("uwvonchcrvfyfujp")
    public suspend
    fun nCrossValidations(`value`: Either<AutoNCrossValidationsArgs, CustomNCrossValidationsArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.nCrossValidations = mapped
    }

    /**
     * @param value Number of cross validation folds to be applied on training dataset
     * when validation dataset is not provided.
     */
    @JvmName("pdqgeogpeypkqipg")
    public fun nCrossValidations(`value`: AutoNCrossValidationsArgs) {
        val toBeMapped = Either.ofLeft<AutoNCrossValidationsArgs, CustomNCrossValidationsArgs>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.nCrossValidations = mapped
    }

    /**
     * @param value Number of cross validation folds to be applied on training dataset
     * when validation dataset is not provided.
     */
    @JvmName("obguotmxrqnuovqj")
    public fun nCrossValidations(`value`: CustomNCrossValidationsArgs) {
        val toBeMapped = Either.ofRight<AutoNCrossValidationsArgs, CustomNCrossValidationsArgs>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.nCrossValidations = mapped
    }

    /**
     * @param value Positive label for binary metrics calculation.
     */
    @JvmName("ishtrnxeiaosexil")
    public suspend fun positiveLabel(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.positiveLabel = mapped
    }

    /**
     * @param value Primary metric for the task.
     */
    @JvmName("ogeqsdpvcupfktul")
    public suspend fun primaryMetric(`value`: Either<String, ClassificationPrimaryMetrics>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.primaryMetric = mapped
    }

    /**
     * @param value Primary metric for the task.
     */
    @JvmName("khqxlgkktygqwgea")
    public fun primaryMetric(`value`: String) {
        val toBeMapped = Either.ofLeft<String, ClassificationPrimaryMetrics>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.primaryMetric = mapped
    }

    /**
     * @param value Primary metric for the task.
     */
    @JvmName("weiqjrslkokrcult")
    public fun primaryMetric(`value`: ClassificationPrimaryMetrics) {
        val toBeMapped = Either.ofRight<String, ClassificationPrimaryMetrics>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.primaryMetric = mapped
    }

    /**
     * @param value Target column name: This is prediction values column.
     * Also known as label column name in context of classification tasks.
     */
    @JvmName("rpeylynjlsmmdnys")
    public suspend fun targetColumnName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.targetColumnName = mapped
    }

    /**
     * @param value AutoMLJob Task type.
     * Expected value is 'Classification'.
     */
    @JvmName("mwvnilkwhjwjwder")
    public suspend fun taskType(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.taskType = mapped
    }

    /**
     * @param value Test data input.
     */
    @JvmName("gdamyrximtqunyrc")
    public suspend fun testData(`value`: MLTableJobInputArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.testData = mapped
    }

    /**
     * @param argument Test data input.
     */
    @JvmName("nkuqbgvaxugvssyx")
    public suspend fun testData(argument: suspend MLTableJobInputArgsBuilder.() -> Unit) {
        val toBeMapped = MLTableJobInputArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.testData = mapped
    }

    /**
     * @param value The fraction of test dataset that needs to be set aside for validation purpose.
     * Values between (0.0 , 1.0)
     * Applied when validation dataset is not provided.
     */
    @JvmName("edqcoajyquqhflap")
    public suspend fun testDataSize(`value`: Double?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.testDataSize = mapped
    }

    /**
     * @param value [Required] Training data input.
     */
    @JvmName("xpmbfmhpjdinhsuy")
    public suspend fun trainingData(`value`: MLTableJobInputArgs) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.trainingData = mapped
    }

    /**
     * @param argument [Required] Training data input.
     */
    @JvmName("kxfcspgxrkrwwfgi")
    public suspend fun trainingData(argument: suspend MLTableJobInputArgsBuilder.() -> Unit) {
        val toBeMapped = MLTableJobInputArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.trainingData = mapped
    }

    /**
     * @param value Inputs for training phase for an AutoML Job.
     */
    @JvmName("mhjqbqthoymnedbd")
    public suspend fun trainingSettings(`value`: ClassificationTrainingSettingsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.trainingSettings = mapped
    }

    /**
     * @param argument Inputs for training phase for an AutoML Job.
     */
    @JvmName("hvrpaiuikvfpcrai")
    public suspend
    fun trainingSettings(argument: suspend ClassificationTrainingSettingsArgsBuilder.() -> Unit) {
        val toBeMapped = ClassificationTrainingSettingsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.trainingSettings = mapped
    }

    /**
     * @param value Validation data inputs.
     */
    @JvmName("oeuksioyljuniasj")
    public suspend fun validationData(`value`: MLTableJobInputArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.validationData = mapped
    }

    /**
     * @param argument Validation data inputs.
     */
    @JvmName("ybudkilncyhxtpow")
    public suspend fun validationData(argument: suspend MLTableJobInputArgsBuilder.() -> Unit) {
        val toBeMapped = MLTableJobInputArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.validationData = mapped
    }

    /**
     * @param value The fraction of training dataset that needs to be set aside for validation purpose.
     * Values between (0.0 , 1.0)
     * Applied when validation dataset is not provided.
     */
    @JvmName("ghdvjtkjxahjrfak")
    public suspend fun validationDataSize(`value`: Double?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.validationDataSize = mapped
    }

    /**
     * @param value The name of the sample weight column. Automated ML supports a weighted column as an input, causing rows in the data to be weighted up or down.
     */
    @JvmName("qyagrladipqsladw")
    public suspend fun weightColumnName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.weightColumnName = mapped
    }

    internal fun build(): ClassificationArgs = ClassificationArgs(
        cvSplitColumnNames = cvSplitColumnNames,
        featurizationSettings = featurizationSettings,
        limitSettings = limitSettings,
        logVerbosity = logVerbosity,
        nCrossValidations = nCrossValidations,
        positiveLabel = positiveLabel,
        primaryMetric = primaryMetric,
        targetColumnName = targetColumnName,
        taskType = taskType ?: throw PulumiNullFieldException("taskType"),
        testData = testData,
        testDataSize = testDataSize,
        trainingData = trainingData ?: throw PulumiNullFieldException("trainingData"),
        trainingSettings = trainingSettings,
        validationData = validationData,
        validationDataSize = validationDataSize,
        weightColumnName = weightColumnName,
    )
}
