@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.machinelearningservices.kotlin.inputs

import com.pulumi.azurenative.machinelearningservices.inputs.ComputeInstanceSshSettingsArgs.builder
import com.pulumi.azurenative.machinelearningservices.kotlin.enums.SshPublicAccess
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Specifies policy and settings for SSH access.
 * @property adminPublicKey Specifies the SSH rsa public key file as a string. Use "ssh-keygen -t rsa -b 2048" to generate your SSH key pairs.
 * @property sshPublicAccess State of the public SSH port. Possible values are: Disabled - Indicates that the public ssh port is closed on this instance. Enabled - Indicates that the public ssh port is open and accessible according to the VNet/subnet policy if applicable.
 */
public data class ComputeInstanceSshSettingsArgs(
    public val adminPublicKey: Output<String>? = null,
    public val sshPublicAccess: Output<Either<String, SshPublicAccess>>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.machinelearningservices.inputs.ComputeInstanceSshSettingsArgs> {
    override fun toJava():
        com.pulumi.azurenative.machinelearningservices.inputs.ComputeInstanceSshSettingsArgs =
        com.pulumi.azurenative.machinelearningservices.inputs.ComputeInstanceSshSettingsArgs.builder()
            .adminPublicKey(adminPublicKey?.applyValue({ args0 -> args0 }))
            .sshPublicAccess(
                sshPublicAccess?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            ).build()
}

/**
 * Builder for [ComputeInstanceSshSettingsArgs].
 */
@PulumiTagMarker
public class ComputeInstanceSshSettingsArgsBuilder internal constructor() {
    private var adminPublicKey: Output<String>? = null

    private var sshPublicAccess: Output<Either<String, SshPublicAccess>>? = null

    /**
     * @param value Specifies the SSH rsa public key file as a string. Use "ssh-keygen -t rsa -b 2048" to generate your SSH key pairs.
     */
    @JvmName("wcluarjcdmvyepfe")
    public suspend fun adminPublicKey(`value`: Output<String>) {
        this.adminPublicKey = value
    }

    /**
     * @param value State of the public SSH port. Possible values are: Disabled - Indicates that the public ssh port is closed on this instance. Enabled - Indicates that the public ssh port is open and accessible according to the VNet/subnet policy if applicable.
     */
    @JvmName("hfqbmeohspygvdqc")
    public suspend fun sshPublicAccess(`value`: Output<Either<String, SshPublicAccess>>) {
        this.sshPublicAccess = value
    }

    /**
     * @param value Specifies the SSH rsa public key file as a string. Use "ssh-keygen -t rsa -b 2048" to generate your SSH key pairs.
     */
    @JvmName("ilwmqsfdjkmivtdi")
    public suspend fun adminPublicKey(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.adminPublicKey = mapped
    }

    /**
     * @param value State of the public SSH port. Possible values are: Disabled - Indicates that the public ssh port is closed on this instance. Enabled - Indicates that the public ssh port is open and accessible according to the VNet/subnet policy if applicable.
     */
    @JvmName("oddnwngyvdfpbjrl")
    public suspend fun sshPublicAccess(`value`: Either<String, SshPublicAccess>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sshPublicAccess = mapped
    }

    /**
     * @param value State of the public SSH port. Possible values are: Disabled - Indicates that the public ssh port is closed on this instance. Enabled - Indicates that the public ssh port is open and accessible according to the VNet/subnet policy if applicable.
     */
    @JvmName("ohauinmsexkthkmx")
    public fun sshPublicAccess(`value`: String) {
        val toBeMapped = Either.ofLeft<String, SshPublicAccess>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.sshPublicAccess = mapped
    }

    /**
     * @param value State of the public SSH port. Possible values are: Disabled - Indicates that the public ssh port is closed on this instance. Enabled - Indicates that the public ssh port is open and accessible according to the VNet/subnet policy if applicable.
     */
    @JvmName("wsofhnpulltmlrvc")
    public fun sshPublicAccess(`value`: SshPublicAccess) {
        val toBeMapped = Either.ofRight<String, SshPublicAccess>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.sshPublicAccess = mapped
    }

    internal fun build(): ComputeInstanceSshSettingsArgs = ComputeInstanceSshSettingsArgs(
        adminPublicKey = adminPublicKey,
        sshPublicAccess = sshPublicAccess,
    )
}
