@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.machinelearningservices.kotlin.inputs

import com.pulumi.azurenative.machinelearningservices.inputs.ComputeSchedulesArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * The list of schedules to be applied on the computes
 * @property computeStartStop The list of compute start stop schedules to be applied.
 */
public data class ComputeSchedulesArgs(
    public val computeStartStop: Output<List<ComputeStartStopScheduleArgs>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.machinelearningservices.inputs.ComputeSchedulesArgs> {
    override fun toJava(): com.pulumi.azurenative.machinelearningservices.inputs.ComputeSchedulesArgs =
        com.pulumi.azurenative.machinelearningservices.inputs.ComputeSchedulesArgs.builder()
            .computeStartStop(
                computeStartStop?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [ComputeSchedulesArgs].
 */
@PulumiTagMarker
public class ComputeSchedulesArgsBuilder internal constructor() {
    private var computeStartStop: Output<List<ComputeStartStopScheduleArgs>>? = null

    /**
     * @param value The list of compute start stop schedules to be applied.
     */
    @JvmName("htyuxoefgpxxwcpm")
    public suspend fun computeStartStop(`value`: Output<List<ComputeStartStopScheduleArgs>>) {
        this.computeStartStop = value
    }

    @JvmName("dljwsoukhhmdevyw")
    public suspend fun computeStartStop(vararg values: Output<ComputeStartStopScheduleArgs>) {
        this.computeStartStop = Output.all(values.asList())
    }

    /**
     * @param values The list of compute start stop schedules to be applied.
     */
    @JvmName("ewbsbrlndwbowmlt")
    public suspend fun computeStartStop(values: List<Output<ComputeStartStopScheduleArgs>>) {
        this.computeStartStop = Output.all(values)
    }

    /**
     * @param value The list of compute start stop schedules to be applied.
     */
    @JvmName("mcvgofaqnmjlgpab")
    public suspend fun computeStartStop(`value`: List<ComputeStartStopScheduleArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.computeStartStop = mapped
    }

    /**
     * @param argument The list of compute start stop schedules to be applied.
     */
    @JvmName("jtqjvqclnxnnthhe")
    public suspend
    fun computeStartStop(argument: List<suspend ComputeStartStopScheduleArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            ComputeStartStopScheduleArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.computeStartStop = mapped
    }

    /**
     * @param argument The list of compute start stop schedules to be applied.
     */
    @JvmName("rvjglftlocqbjlls")
    public suspend fun computeStartStop(
        vararg
        argument: suspend ComputeStartStopScheduleArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            ComputeStartStopScheduleArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.computeStartStop = mapped
    }

    /**
     * @param argument The list of compute start stop schedules to be applied.
     */
    @JvmName("svodsunwyvngqcbg")
    public suspend
    fun computeStartStop(argument: suspend ComputeStartStopScheduleArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            ComputeStartStopScheduleArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.computeStartStop = mapped
    }

    /**
     * @param values The list of compute start stop schedules to be applied.
     */
    @JvmName("fbnuegnptfsqoggm")
    public suspend fun computeStartStop(vararg values: ComputeStartStopScheduleArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.computeStartStop = mapped
    }

    internal fun build(): ComputeSchedulesArgs = ComputeSchedulesArgs(
        computeStartStop = computeStartStop,
    )
}
