@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.machinelearningservices.kotlin.inputs

import com.pulumi.azurenative.machinelearningservices.inputs.ContainerResourceRequirementsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Resource requirements for each container instance within an online deployment.
 * @property containerResourceLimits Container resource limit info:
 * @property containerResourceRequests Container resource request info:
 */
public data class ContainerResourceRequirementsArgs(
    public val containerResourceLimits: Output<ContainerResourceSettingsArgs>? = null,
    public val containerResourceRequests: Output<ContainerResourceSettingsArgs>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.machinelearningservices.inputs.ContainerResourceRequirementsArgs> {
    override fun toJava():
        com.pulumi.azurenative.machinelearningservices.inputs.ContainerResourceRequirementsArgs =
        com.pulumi.azurenative.machinelearningservices.inputs.ContainerResourceRequirementsArgs.builder()
            .containerResourceLimits(
                containerResourceLimits?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .containerResourceRequests(
                containerResourceRequests?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            ).build()
}

/**
 * Builder for [ContainerResourceRequirementsArgs].
 */
@PulumiTagMarker
public class ContainerResourceRequirementsArgsBuilder internal constructor() {
    private var containerResourceLimits: Output<ContainerResourceSettingsArgs>? = null

    private var containerResourceRequests: Output<ContainerResourceSettingsArgs>? = null

    /**
     * @param value Container resource limit info:
     */
    @JvmName("atgrqrgctbrcfjom")
    public suspend fun containerResourceLimits(`value`: Output<ContainerResourceSettingsArgs>) {
        this.containerResourceLimits = value
    }

    /**
     * @param value Container resource request info:
     */
    @JvmName("dyrwmmbjkpoqgkfh")
    public suspend fun containerResourceRequests(`value`: Output<ContainerResourceSettingsArgs>) {
        this.containerResourceRequests = value
    }

    /**
     * @param value Container resource limit info:
     */
    @JvmName("faivwxjrhyhmpmop")
    public suspend fun containerResourceLimits(`value`: ContainerResourceSettingsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.containerResourceLimits = mapped
    }

    /**
     * @param argument Container resource limit info:
     */
    @JvmName("hnwnfmemtanvhykf")
    public suspend
    fun containerResourceLimits(argument: suspend ContainerResourceSettingsArgsBuilder.() -> Unit) {
        val toBeMapped = ContainerResourceSettingsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.containerResourceLimits = mapped
    }

    /**
     * @param value Container resource request info:
     */
    @JvmName("vbeyvnxxxkonfwmf")
    public suspend fun containerResourceRequests(`value`: ContainerResourceSettingsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.containerResourceRequests = mapped
    }

    /**
     * @param argument Container resource request info:
     */
    @JvmName("nixaiyskbcfnymrh")
    public suspend
    fun containerResourceRequests(argument: suspend ContainerResourceSettingsArgsBuilder.() -> Unit) {
        val toBeMapped = ContainerResourceSettingsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.containerResourceRequests = mapped
    }

    internal fun build(): ContainerResourceRequirementsArgs = ContainerResourceRequirementsArgs(
        containerResourceLimits = containerResourceLimits,
        containerResourceRequests = containerResourceRequests,
    )
}
