@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.machinelearningservices.kotlin.inputs

import com.pulumi.azurenative.machinelearningservices.inputs.CosmosDbSettingsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property collectionsThroughput The throughput of the collections in cosmosdb database
 */
public data class CosmosDbSettingsArgs(
    public val collectionsThroughput: Output<Int>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.machinelearningservices.inputs.CosmosDbSettingsArgs> {
    override fun toJava(): com.pulumi.azurenative.machinelearningservices.inputs.CosmosDbSettingsArgs =
        com.pulumi.azurenative.machinelearningservices.inputs.CosmosDbSettingsArgs.builder()
            .collectionsThroughput(collectionsThroughput?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [CosmosDbSettingsArgs].
 */
@PulumiTagMarker
public class CosmosDbSettingsArgsBuilder internal constructor() {
    private var collectionsThroughput: Output<Int>? = null

    /**
     * @param value The throughput of the collections in cosmosdb database
     */
    @JvmName("prxeabogbxbtnpue")
    public suspend fun collectionsThroughput(`value`: Output<Int>) {
        this.collectionsThroughput = value
    }

    /**
     * @param value The throughput of the collections in cosmosdb database
     */
    @JvmName("qtmqpcfxxaolgqrv")
    public suspend fun collectionsThroughput(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.collectionsThroughput = mapped
    }

    internal fun build(): CosmosDbSettingsArgs = CosmosDbSettingsArgs(
        collectionsThroughput = collectionsThroughput,
    )
}
