@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.machinelearningservices.kotlin.inputs

import com.pulumi.azurenative.machinelearningservices.inputs.DatasetCreateRequestParametersArgs.builder
import com.pulumi.azurenative.machinelearningservices.kotlin.enums.Header
import com.pulumi.azurenative.machinelearningservices.kotlin.enums.SourceType
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property header Header type.
 * @property includePath Boolean to keep path information as column in the dataset. Defaults to False. This is useful when reading multiple files, and want to know which file a particular record originated from, or to keep useful information in file path.
 * @property partitionFormat The partition information of each path will be extracted into columns based on the specified format. Format part '{column_name}' creates string column, and '{column_name:yyyy/MM/dd/HH/mm/ss}' creates datetime column, where 'yyyy', 'MM', 'dd', 'HH', 'mm' and 'ss' are used to extract year, month, day, hour, minute and second for the datetime type. The format should start from the position of first partition key until the end of file path. For example, given the path '../USA/2019/01/01/data.parquet' where the partition is by country/region and time, partition_format='/{CountryOrRegion}/{PartitionDate:yyyy/MM/dd}/data.csv' creates a string column 'CountryOrRegion' with the value 'USA' and a datetime column 'PartitionDate' with the value '2019-01-01
 * @property path
 * @property query
 * @property separator The separator used to split columns for 'delimited_files' sourceType.
 * @property sourceType Data source type.
 */
public data class DatasetCreateRequestParametersArgs(
    public val `header`: Output<Either<String, Header>>? = null,
    public val includePath: Output<Boolean>? = null,
    public val partitionFormat: Output<String>? = null,
    public val path: Output<DatasetCreateRequestPathArgs>? = null,
    public val query: Output<DatasetCreateRequestQueryArgs>? = null,
    public val separator: Output<String>? = null,
    public val sourceType: Output<Either<String, SourceType>>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.machinelearningservices.inputs.DatasetCreateRequestParametersArgs> {
    override fun toJava():
        com.pulumi.azurenative.machinelearningservices.inputs.DatasetCreateRequestParametersArgs =
        com.pulumi.azurenative.machinelearningservices.inputs.DatasetCreateRequestParametersArgs.builder()
            .`header`(
                `header`?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .includePath(includePath?.applyValue({ args0 -> args0 }))
            .partitionFormat(partitionFormat?.applyValue({ args0 -> args0 }))
            .path(path?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .query(query?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .separator(separator?.applyValue({ args0 -> args0 }))
            .sourceType(
                sourceType?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            ).build()
}

/**
 * Builder for [DatasetCreateRequestParametersArgs].
 */
@PulumiTagMarker
public class DatasetCreateRequestParametersArgsBuilder internal constructor() {
    private var `header`: Output<Either<String, Header>>? = null

    private var includePath: Output<Boolean>? = null

    private var partitionFormat: Output<String>? = null

    private var path: Output<DatasetCreateRequestPathArgs>? = null

    private var query: Output<DatasetCreateRequestQueryArgs>? = null

    private var separator: Output<String>? = null

    private var sourceType: Output<Either<String, SourceType>>? = null

    /**
     * @param value Header type.
     */
    @JvmName("lfruxisqmgbwwiti")
    public suspend fun `header`(`value`: Output<Either<String, Header>>) {
        this.`header` = value
    }

    /**
     * @param value Boolean to keep path information as column in the dataset. Defaults to False. This is useful when reading multiple files, and want to know which file a particular record originated from, or to keep useful information in file path.
     */
    @JvmName("tubcaxtkpucjmstf")
    public suspend fun includePath(`value`: Output<Boolean>) {
        this.includePath = value
    }

    /**
     * @param value The partition information of each path will be extracted into columns based on the specified format. Format part '{column_name}' creates string column, and '{column_name:yyyy/MM/dd/HH/mm/ss}' creates datetime column, where 'yyyy', 'MM', 'dd', 'HH', 'mm' and 'ss' are used to extract year, month, day, hour, minute and second for the datetime type. The format should start from the position of first partition key until the end of file path. For example, given the path '../USA/2019/01/01/data.parquet' where the partition is by country/region and time, partition_format='/{CountryOrRegion}/{PartitionDate:yyyy/MM/dd}/data.csv' creates a string column 'CountryOrRegion' with the value 'USA' and a datetime column 'PartitionDate' with the value '2019-01-01
     */
    @JvmName("hxtremowcmuascid")
    public suspend fun partitionFormat(`value`: Output<String>) {
        this.partitionFormat = value
    }

    /**
     * @param value
     */
    @JvmName("gkyaxdktlqedeqbb")
    public suspend fun path(`value`: Output<DatasetCreateRequestPathArgs>) {
        this.path = value
    }

    /**
     * @param value
     */
    @JvmName("xaeiqnlxhmganhid")
    public suspend fun query(`value`: Output<DatasetCreateRequestQueryArgs>) {
        this.query = value
    }

    /**
     * @param value The separator used to split columns for 'delimited_files' sourceType.
     */
    @JvmName("yriuiqyaojaaubnq")
    public suspend fun separator(`value`: Output<String>) {
        this.separator = value
    }

    /**
     * @param value Data source type.
     */
    @JvmName("efksxttdtxhetard")
    public suspend fun sourceType(`value`: Output<Either<String, SourceType>>) {
        this.sourceType = value
    }

    /**
     * @param value Header type.
     */
    @JvmName("byssrmxpacvcbxkt")
    public suspend fun `header`(`value`: Either<String, Header>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.`header` = mapped
    }

    /**
     * @param value Header type.
     */
    @JvmName("uavwgdfdcupbabxe")
    public fun `header`(`value`: String) {
        val toBeMapped = Either.ofLeft<String, Header>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.`header` = mapped
    }

    /**
     * @param value Header type.
     */
    @JvmName("wkpyoxkwtufncacj")
    public fun `header`(`value`: Header) {
        val toBeMapped = Either.ofRight<String, Header>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.`header` = mapped
    }

    /**
     * @param value Boolean to keep path information as column in the dataset. Defaults to False. This is useful when reading multiple files, and want to know which file a particular record originated from, or to keep useful information in file path.
     */
    @JvmName("vyjxaaclhhyyxrvd")
    public suspend fun includePath(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.includePath = mapped
    }

    /**
     * @param value The partition information of each path will be extracted into columns based on the specified format. Format part '{column_name}' creates string column, and '{column_name:yyyy/MM/dd/HH/mm/ss}' creates datetime column, where 'yyyy', 'MM', 'dd', 'HH', 'mm' and 'ss' are used to extract year, month, day, hour, minute and second for the datetime type. The format should start from the position of first partition key until the end of file path. For example, given the path '../USA/2019/01/01/data.parquet' where the partition is by country/region and time, partition_format='/{CountryOrRegion}/{PartitionDate:yyyy/MM/dd}/data.csv' creates a string column 'CountryOrRegion' with the value 'USA' and a datetime column 'PartitionDate' with the value '2019-01-01
     */
    @JvmName("vywoylwblgxtiijk")
    public suspend fun partitionFormat(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.partitionFormat = mapped
    }

    /**
     * @param value
     */
    @JvmName("ulpksgruldctujmc")
    public suspend fun path(`value`: DatasetCreateRequestPathArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.path = mapped
    }

    /**
     * @param argument
     */
    @JvmName("geviomtcpwdfespl")
    public suspend fun path(argument: suspend DatasetCreateRequestPathArgsBuilder.() -> Unit) {
        val toBeMapped = DatasetCreateRequestPathArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.path = mapped
    }

    /**
     * @param value
     */
    @JvmName("bhcjfsmcxcjvrubr")
    public suspend fun query(`value`: DatasetCreateRequestQueryArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.query = mapped
    }

    /**
     * @param argument
     */
    @JvmName("desyvewhfuojqorc")
    public suspend fun query(argument: suspend DatasetCreateRequestQueryArgsBuilder.() -> Unit) {
        val toBeMapped = DatasetCreateRequestQueryArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.query = mapped
    }

    /**
     * @param value The separator used to split columns for 'delimited_files' sourceType.
     */
    @JvmName("ncvmcfaiyeodnhku")
    public suspend fun separator(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.separator = mapped
    }

    /**
     * @param value Data source type.
     */
    @JvmName("qhjetjjprriusjrg")
    public suspend fun sourceType(`value`: Either<String, SourceType>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sourceType = mapped
    }

    /**
     * @param value Data source type.
     */
    @JvmName("iwyvtkuwxeidwbtu")
    public fun sourceType(`value`: String) {
        val toBeMapped = Either.ofLeft<String, SourceType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.sourceType = mapped
    }

    /**
     * @param value Data source type.
     */
    @JvmName("ggcohtrhripemieq")
    public fun sourceType(`value`: SourceType) {
        val toBeMapped = Either.ofRight<String, SourceType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.sourceType = mapped
    }

    internal fun build(): DatasetCreateRequestParametersArgs = DatasetCreateRequestParametersArgs(
        `header` = `header`,
        includePath = includePath,
        partitionFormat = partitionFormat,
        path = path,
        query = query,
        separator = separator,
        sourceType = sourceType,
    )
}
