@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.machinelearningservices.kotlin.inputs

import com.pulumi.azurenative.machinelearningservices.inputs.DatasetCreateRequestPathArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property dataPath
 * @property httpUrl The Http URL.
 */
public data class DatasetCreateRequestPathArgs(
    public val dataPath: Output<DatasetCreateRequestDataPathArgs>? = null,
    public val httpUrl: Output<String>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.machinelearningservices.inputs.DatasetCreateRequestPathArgs> {
    override fun toJava():
        com.pulumi.azurenative.machinelearningservices.inputs.DatasetCreateRequestPathArgs =
        com.pulumi.azurenative.machinelearningservices.inputs.DatasetCreateRequestPathArgs.builder()
            .dataPath(dataPath?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .httpUrl(httpUrl?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [DatasetCreateRequestPathArgs].
 */
@PulumiTagMarker
public class DatasetCreateRequestPathArgsBuilder internal constructor() {
    private var dataPath: Output<DatasetCreateRequestDataPathArgs>? = null

    private var httpUrl: Output<String>? = null

    /**
     * @param value
     */
    @JvmName("rwgomlutrwkawldo")
    public suspend fun dataPath(`value`: Output<DatasetCreateRequestDataPathArgs>) {
        this.dataPath = value
    }

    /**
     * @param value The Http URL.
     */
    @JvmName("xljnbpysdjrxxhjm")
    public suspend fun httpUrl(`value`: Output<String>) {
        this.httpUrl = value
    }

    /**
     * @param value
     */
    @JvmName("dcvclrxgoesroonj")
    public suspend fun dataPath(`value`: DatasetCreateRequestDataPathArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dataPath = mapped
    }

    /**
     * @param argument
     */
    @JvmName("iuenrrlgykrdsrpu")
    public suspend
    fun dataPath(argument: suspend DatasetCreateRequestDataPathArgsBuilder.() -> Unit) {
        val toBeMapped = DatasetCreateRequestDataPathArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.dataPath = mapped
    }

    /**
     * @param value The Http URL.
     */
    @JvmName("elwisvmuykhpaanq")
    public suspend fun httpUrl(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.httpUrl = mapped
    }

    internal fun build(): DatasetCreateRequestPathArgs = DatasetCreateRequestPathArgs(
        dataPath = dataPath,
        httpUrl = httpUrl,
    )
}
