@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.machinelearningservices.kotlin.inputs

import com.pulumi.azurenative.machinelearningservices.inputs.DeploymentResourceConfigurationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Any
import kotlin.Int
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 *
 * @property instanceCount Optional number of instances or nodes used by the compute target.
 * @property instanceType Optional type of VM used as supported by the compute target.
 * @property properties Additional properties bag.
 */
public data class DeploymentResourceConfigurationArgs(
    public val instanceCount: Output<Int>? = null,
    public val instanceType: Output<String>? = null,
    public val properties: Output<Map<String, Any>>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.machinelearningservices.inputs.DeploymentResourceConfigurationArgs> {
    override fun toJava():
        com.pulumi.azurenative.machinelearningservices.inputs.DeploymentResourceConfigurationArgs =
        com.pulumi.azurenative.machinelearningservices.inputs.DeploymentResourceConfigurationArgs.builder()
            .instanceCount(instanceCount?.applyValue({ args0 -> args0 }))
            .instanceType(instanceType?.applyValue({ args0 -> args0 }))
            .properties(
                properties?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [DeploymentResourceConfigurationArgs].
 */
@PulumiTagMarker
public class DeploymentResourceConfigurationArgsBuilder internal constructor() {
    private var instanceCount: Output<Int>? = null

    private var instanceType: Output<String>? = null

    private var properties: Output<Map<String, Any>>? = null

    /**
     * @param value Optional number of instances or nodes used by the compute target.
     */
    @JvmName("fwayduqvxldmjmgj")
    public suspend fun instanceCount(`value`: Output<Int>) {
        this.instanceCount = value
    }

    /**
     * @param value Optional type of VM used as supported by the compute target.
     */
    @JvmName("upfsnufiuajiocvc")
    public suspend fun instanceType(`value`: Output<String>) {
        this.instanceType = value
    }

    /**
     * @param value Additional properties bag.
     */
    @JvmName("ismfosbvuamxihir")
    public suspend fun properties(`value`: Output<Map<String, Any>>) {
        this.properties = value
    }

    /**
     * @param value Optional number of instances or nodes used by the compute target.
     */
    @JvmName("nitawrhdbvrecdkq")
    public suspend fun instanceCount(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.instanceCount = mapped
    }

    /**
     * @param value Optional type of VM used as supported by the compute target.
     */
    @JvmName("jwihlnnwsgkrcule")
    public suspend fun instanceType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.instanceType = mapped
    }

    /**
     * @param value Additional properties bag.
     */
    @JvmName("xbueehlijdqbnury")
    public suspend fun properties(`value`: Map<String, Any>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.properties = mapped
    }

    /**
     * @param values Additional properties bag.
     */
    @JvmName("rtmhdhiabskfleos")
    public fun properties(vararg values: Pair<String, Any>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.properties = mapped
    }

    internal fun build(): DeploymentResourceConfigurationArgs = DeploymentResourceConfigurationArgs(
        instanceCount = instanceCount,
        instanceType = instanceType,
        properties = properties,
    )
}
