@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.machinelearningservices.kotlin.inputs

import com.pulumi.azurenative.machinelearningservices.inputs.FeaturesetVersionArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Dto object representing feature set version
 * @property autoDeleteSetting Specifies the lifecycle setting of managed data asset.
 * @property description The asset description text.
 * @property entities Specifies list of entities
 * @property isAnonymous If the name version are system generated (anonymous registration). For types where Stage is defined, when Stage is provided it will be used to populate IsAnonymous
 * @property isArchived Is the asset archived? For types where Stage is defined, when Stage is provided it will be used to populate IsArchived
 * @property materializationSettings Specifies the materialization settings
 * @property properties The asset property dictionary.
 * @property specification Specifies the feature spec details
 * @property stage Specifies the asset stage
 * @property tags Tag dictionary. Tags can be added, removed, and updated.
 */
public data class FeaturesetVersionArgs(
    public val autoDeleteSetting: Output<AutoDeleteSettingArgs>? = null,
    public val description: Output<String>? = null,
    public val entities: Output<List<String>>? = null,
    public val isAnonymous: Output<Boolean>? = null,
    public val isArchived: Output<Boolean>? = null,
    public val materializationSettings: Output<MaterializationSettingsArgs>? = null,
    public val properties: Output<Map<String, String>>? = null,
    public val specification: Output<FeaturesetSpecificationArgs>? = null,
    public val stage: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.machinelearningservices.inputs.FeaturesetVersionArgs> {
    override fun toJava(): com.pulumi.azurenative.machinelearningservices.inputs.FeaturesetVersionArgs =
        com.pulumi.azurenative.machinelearningservices.inputs.FeaturesetVersionArgs.builder()
            .autoDeleteSetting(autoDeleteSetting?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .description(description?.applyValue({ args0 -> args0 }))
            .entities(entities?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .isAnonymous(isAnonymous?.applyValue({ args0 -> args0 }))
            .isArchived(isArchived?.applyValue({ args0 -> args0 }))
            .materializationSettings(
                materializationSettings?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .properties(
                properties?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            )
            .specification(specification?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .stage(stage?.applyValue({ args0 -> args0 }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [FeaturesetVersionArgs].
 */
@PulumiTagMarker
public class FeaturesetVersionArgsBuilder internal constructor() {
    private var autoDeleteSetting: Output<AutoDeleteSettingArgs>? = null

    private var description: Output<String>? = null

    private var entities: Output<List<String>>? = null

    private var isAnonymous: Output<Boolean>? = null

    private var isArchived: Output<Boolean>? = null

    private var materializationSettings: Output<MaterializationSettingsArgs>? = null

    private var properties: Output<Map<String, String>>? = null

    private var specification: Output<FeaturesetSpecificationArgs>? = null

    private var stage: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value Specifies the lifecycle setting of managed data asset.
     */
    @JvmName("sixhyxmijuceihht")
    public suspend fun autoDeleteSetting(`value`: Output<AutoDeleteSettingArgs>) {
        this.autoDeleteSetting = value
    }

    /**
     * @param value The asset description text.
     */
    @JvmName("lfshytdqspovslcr")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value Specifies list of entities
     */
    @JvmName("gvttronrlpfjsjmf")
    public suspend fun entities(`value`: Output<List<String>>) {
        this.entities = value
    }

    @JvmName("hxnvghglywprcwpb")
    public suspend fun entities(vararg values: Output<String>) {
        this.entities = Output.all(values.asList())
    }

    /**
     * @param values Specifies list of entities
     */
    @JvmName("gggfhajxlecmpiir")
    public suspend fun entities(values: List<Output<String>>) {
        this.entities = Output.all(values)
    }

    /**
     * @param value If the name version are system generated (anonymous registration). For types where Stage is defined, when Stage is provided it will be used to populate IsAnonymous
     */
    @JvmName("waxuvyvuktmbvqdb")
    public suspend fun isAnonymous(`value`: Output<Boolean>) {
        this.isAnonymous = value
    }

    /**
     * @param value Is the asset archived? For types where Stage is defined, when Stage is provided it will be used to populate IsArchived
     */
    @JvmName("fbabqkrtkxsonajg")
    public suspend fun isArchived(`value`: Output<Boolean>) {
        this.isArchived = value
    }

    /**
     * @param value Specifies the materialization settings
     */
    @JvmName("vjikkjjaflbfsghi")
    public suspend fun materializationSettings(`value`: Output<MaterializationSettingsArgs>) {
        this.materializationSettings = value
    }

    /**
     * @param value The asset property dictionary.
     */
    @JvmName("bfmwuabtsxplksgc")
    public suspend fun properties(`value`: Output<Map<String, String>>) {
        this.properties = value
    }

    /**
     * @param value Specifies the feature spec details
     */
    @JvmName("biqaqqprwqywykao")
    public suspend fun specification(`value`: Output<FeaturesetSpecificationArgs>) {
        this.specification = value
    }

    /**
     * @param value Specifies the asset stage
     */
    @JvmName("ariulbwnunfihrpw")
    public suspend fun stage(`value`: Output<String>) {
        this.stage = value
    }

    /**
     * @param value Tag dictionary. Tags can be added, removed, and updated.
     */
    @JvmName("vliskgajoammjujg")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value Specifies the lifecycle setting of managed data asset.
     */
    @JvmName("fsdlchyaefmqhnbx")
    public suspend fun autoDeleteSetting(`value`: AutoDeleteSettingArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.autoDeleteSetting = mapped
    }

    /**
     * @param argument Specifies the lifecycle setting of managed data asset.
     */
    @JvmName("froamhmugngyjjvm")
    public suspend fun autoDeleteSetting(argument: suspend AutoDeleteSettingArgsBuilder.() -> Unit) {
        val toBeMapped = AutoDeleteSettingArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.autoDeleteSetting = mapped
    }

    /**
     * @param value The asset description text.
     */
    @JvmName("tkmsqbsywrrlxgpv")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value Specifies list of entities
     */
    @JvmName("qouvwogwdgjykfhj")
    public suspend fun entities(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.entities = mapped
    }

    /**
     * @param values Specifies list of entities
     */
    @JvmName("sfdgpysgtudsmith")
    public suspend fun entities(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.entities = mapped
    }

    /**
     * @param value If the name version are system generated (anonymous registration). For types where Stage is defined, when Stage is provided it will be used to populate IsAnonymous
     */
    @JvmName("mjvjigaxrsocbebx")
    public suspend fun isAnonymous(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.isAnonymous = mapped
    }

    /**
     * @param value Is the asset archived? For types where Stage is defined, when Stage is provided it will be used to populate IsArchived
     */
    @JvmName("htopaoxkcmsnoyex")
    public suspend fun isArchived(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.isArchived = mapped
    }

    /**
     * @param value Specifies the materialization settings
     */
    @JvmName("rlukxojxmfladajh")
    public suspend fun materializationSettings(`value`: MaterializationSettingsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.materializationSettings = mapped
    }

    /**
     * @param argument Specifies the materialization settings
     */
    @JvmName("fdtmcucoaldypsul")
    public suspend
    fun materializationSettings(argument: suspend MaterializationSettingsArgsBuilder.() -> Unit) {
        val toBeMapped = MaterializationSettingsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.materializationSettings = mapped
    }

    /**
     * @param value The asset property dictionary.
     */
    @JvmName("brnhamappcaprqmd")
    public suspend fun properties(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.properties = mapped
    }

    /**
     * @param values The asset property dictionary.
     */
    @JvmName("rispiartvuiwmtvq")
    public fun properties(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.properties = mapped
    }

    /**
     * @param value Specifies the feature spec details
     */
    @JvmName("vcvatoonespdymjc")
    public suspend fun specification(`value`: FeaturesetSpecificationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.specification = mapped
    }

    /**
     * @param argument Specifies the feature spec details
     */
    @JvmName("gkwuircvwguskgfj")
    public suspend
    fun specification(argument: suspend FeaturesetSpecificationArgsBuilder.() -> Unit) {
        val toBeMapped = FeaturesetSpecificationArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.specification = mapped
    }

    /**
     * @param value Specifies the asset stage
     */
    @JvmName("qcnjulqbrmjhgqlh")
    public suspend fun stage(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.stage = mapped
    }

    /**
     * @param value Tag dictionary. Tags can be added, removed, and updated.
     */
    @JvmName("jpxlfoqbufrsdtun")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Tag dictionary. Tags can be added, removed, and updated.
     */
    @JvmName("wngtluvhfbgtdhpn")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): FeaturesetVersionArgs = FeaturesetVersionArgs(
        autoDeleteSetting = autoDeleteSetting,
        description = description,
        entities = entities,
        isAnonymous = isAnonymous,
        isArchived = isArchived,
        materializationSettings = materializationSettings,
        properties = properties,
        specification = specification,
        stage = stage,
        tags = tags,
    )
}
