@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.machinelearningservices.kotlin.inputs

import com.pulumi.azurenative.machinelearningservices.inputs.FeaturestoreEntityVersionArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Dto object representing feature entity version
 * @property autoDeleteSetting Specifies the lifecycle setting of managed data asset.
 * @property description The asset description text.
 * @property indexColumns Specifies index columns
 * @property isAnonymous If the name version are system generated (anonymous registration). For types where Stage is defined, when Stage is provided it will be used to populate IsAnonymous
 * @property isArchived Is the asset archived? For types where Stage is defined, when Stage is provided it will be used to populate IsArchived
 * @property properties The asset property dictionary.
 * @property stage Specifies the asset stage
 * @property tags Tag dictionary. Tags can be added, removed, and updated.
 */
public data class FeaturestoreEntityVersionArgs(
    public val autoDeleteSetting: Output<AutoDeleteSettingArgs>? = null,
    public val description: Output<String>? = null,
    public val indexColumns: Output<List<IndexColumnArgs>>? = null,
    public val isAnonymous: Output<Boolean>? = null,
    public val isArchived: Output<Boolean>? = null,
    public val properties: Output<Map<String, String>>? = null,
    public val stage: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.machinelearningservices.inputs.FeaturestoreEntityVersionArgs> {
    override fun toJava():
        com.pulumi.azurenative.machinelearningservices.inputs.FeaturestoreEntityVersionArgs =
        com.pulumi.azurenative.machinelearningservices.inputs.FeaturestoreEntityVersionArgs.builder()
            .autoDeleteSetting(autoDeleteSetting?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .description(description?.applyValue({ args0 -> args0 }))
            .indexColumns(
                indexColumns?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .isAnonymous(isAnonymous?.applyValue({ args0 -> args0 }))
            .isArchived(isArchived?.applyValue({ args0 -> args0 }))
            .properties(
                properties?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            )
            .stage(stage?.applyValue({ args0 -> args0 }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [FeaturestoreEntityVersionArgs].
 */
@PulumiTagMarker
public class FeaturestoreEntityVersionArgsBuilder internal constructor() {
    private var autoDeleteSetting: Output<AutoDeleteSettingArgs>? = null

    private var description: Output<String>? = null

    private var indexColumns: Output<List<IndexColumnArgs>>? = null

    private var isAnonymous: Output<Boolean>? = null

    private var isArchived: Output<Boolean>? = null

    private var properties: Output<Map<String, String>>? = null

    private var stage: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value Specifies the lifecycle setting of managed data asset.
     */
    @JvmName("iiohjrkfqleaevaj")
    public suspend fun autoDeleteSetting(`value`: Output<AutoDeleteSettingArgs>) {
        this.autoDeleteSetting = value
    }

    /**
     * @param value The asset description text.
     */
    @JvmName("kdonqlexqiagaltf")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value Specifies index columns
     */
    @JvmName("anaplxpignpecpdc")
    public suspend fun indexColumns(`value`: Output<List<IndexColumnArgs>>) {
        this.indexColumns = value
    }

    @JvmName("fsxnjdbvuinyutct")
    public suspend fun indexColumns(vararg values: Output<IndexColumnArgs>) {
        this.indexColumns = Output.all(values.asList())
    }

    /**
     * @param values Specifies index columns
     */
    @JvmName("yixctcddlanlvefi")
    public suspend fun indexColumns(values: List<Output<IndexColumnArgs>>) {
        this.indexColumns = Output.all(values)
    }

    /**
     * @param value If the name version are system generated (anonymous registration). For types where Stage is defined, when Stage is provided it will be used to populate IsAnonymous
     */
    @JvmName("wkhtnnwchcgcjfgs")
    public suspend fun isAnonymous(`value`: Output<Boolean>) {
        this.isAnonymous = value
    }

    /**
     * @param value Is the asset archived? For types where Stage is defined, when Stage is provided it will be used to populate IsArchived
     */
    @JvmName("ldnxtkandueukets")
    public suspend fun isArchived(`value`: Output<Boolean>) {
        this.isArchived = value
    }

    /**
     * @param value The asset property dictionary.
     */
    @JvmName("ablbiwjhcuiqxvlf")
    public suspend fun properties(`value`: Output<Map<String, String>>) {
        this.properties = value
    }

    /**
     * @param value Specifies the asset stage
     */
    @JvmName("nxsicsmpwhyfhefd")
    public suspend fun stage(`value`: Output<String>) {
        this.stage = value
    }

    /**
     * @param value Tag dictionary. Tags can be added, removed, and updated.
     */
    @JvmName("comnpbbjgfvukajv")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value Specifies the lifecycle setting of managed data asset.
     */
    @JvmName("qtnyelkhdrcpjglp")
    public suspend fun autoDeleteSetting(`value`: AutoDeleteSettingArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.autoDeleteSetting = mapped
    }

    /**
     * @param argument Specifies the lifecycle setting of managed data asset.
     */
    @JvmName("exhtuxxnjgeikkam")
    public suspend fun autoDeleteSetting(argument: suspend AutoDeleteSettingArgsBuilder.() -> Unit) {
        val toBeMapped = AutoDeleteSettingArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.autoDeleteSetting = mapped
    }

    /**
     * @param value The asset description text.
     */
    @JvmName("pkcfmefoxluhtkfp")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value Specifies index columns
     */
    @JvmName("dtgpljqraskacklx")
    public suspend fun indexColumns(`value`: List<IndexColumnArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.indexColumns = mapped
    }

    /**
     * @param argument Specifies index columns
     */
    @JvmName("blpysyptgfnigwgs")
    public suspend fun indexColumns(argument: List<suspend IndexColumnArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map { IndexColumnArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.indexColumns = mapped
    }

    /**
     * @param argument Specifies index columns
     */
    @JvmName("eqntwyfncntwrhsa")
    public suspend fun indexColumns(vararg argument: suspend IndexColumnArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map { IndexColumnArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.indexColumns = mapped
    }

    /**
     * @param argument Specifies index columns
     */
    @JvmName("llgoundwwhmpyyui")
    public suspend fun indexColumns(argument: suspend IndexColumnArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(IndexColumnArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.indexColumns = mapped
    }

    /**
     * @param values Specifies index columns
     */
    @JvmName("efihlwioaqwtcvrd")
    public suspend fun indexColumns(vararg values: IndexColumnArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.indexColumns = mapped
    }

    /**
     * @param value If the name version are system generated (anonymous registration). For types where Stage is defined, when Stage is provided it will be used to populate IsAnonymous
     */
    @JvmName("uhxdpefjfpquwkjp")
    public suspend fun isAnonymous(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.isAnonymous = mapped
    }

    /**
     * @param value Is the asset archived? For types where Stage is defined, when Stage is provided it will be used to populate IsArchived
     */
    @JvmName("kkvokwexhsbtirop")
    public suspend fun isArchived(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.isArchived = mapped
    }

    /**
     * @param value The asset property dictionary.
     */
    @JvmName("hdgycdlloobqpmnl")
    public suspend fun properties(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.properties = mapped
    }

    /**
     * @param values The asset property dictionary.
     */
    @JvmName("apiayghvdujmulvu")
    public fun properties(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.properties = mapped
    }

    /**
     * @param value Specifies the asset stage
     */
    @JvmName("ujtcabjphyadigea")
    public suspend fun stage(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.stage = mapped
    }

    /**
     * @param value Tag dictionary. Tags can be added, removed, and updated.
     */
    @JvmName("rvhpqpkxjgklxhjt")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Tag dictionary. Tags can be added, removed, and updated.
     */
    @JvmName("ltualtfrwiihbobv")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): FeaturestoreEntityVersionArgs = FeaturestoreEntityVersionArgs(
        autoDeleteSetting = autoDeleteSetting,
        description = description,
        indexColumns = indexColumns,
        isAnonymous = isAnonymous,
        isArchived = isArchived,
        properties = properties,
        stage = stage,
        tags = tags,
    )
}
