@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.machinelearningservices.kotlin.inputs

import com.pulumi.azurenative.machinelearningservices.inputs.ForecastingArgs.builder
import com.pulumi.azurenative.machinelearningservices.kotlin.enums.ForecastingPrimaryMetrics
import com.pulumi.azurenative.machinelearningservices.kotlin.enums.LogVerbosity
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Double
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Forecasting task in AutoML Table vertical.
 * @property cvSplitColumnNames Columns to use for CVSplit data.
 * @property featurizationSettings Featurization inputs needed for AutoML job.
 * @property forecastingSettings Forecasting task specific inputs.
 * @property limitSettings Execution constraints for AutoMLJob.
 * @property logVerbosity Log verbosity for the job.
 * @property nCrossValidations Number of cross validation folds to be applied on training dataset
 * when validation dataset is not provided.
 * @property primaryMetric Primary metric for forecasting task.
 * @property targetColumnName Target column name: This is prediction values column.
 * Also known as label column name in context of classification tasks.
 * @property taskType AutoMLJob Task type.
 * Expected value is 'Forecasting'.
 * @property testData Test data input.
 * @property testDataSize The fraction of test dataset that needs to be set aside for validation purpose.
 * Values between (0.0 , 1.0)
 * Applied when validation dataset is not provided.
 * @property trainingData [Required] Training data input.
 * @property trainingSettings Inputs for training phase for an AutoML Job.
 * @property validationData Validation data inputs.
 * @property validationDataSize The fraction of training dataset that needs to be set aside for validation purpose.
 * Values between (0.0 , 1.0)
 * Applied when validation dataset is not provided.
 * @property weightColumnName The name of the sample weight column. Automated ML supports a weighted column as an input, causing rows in the data to be weighted up or down.
 */
public data class ForecastingArgs(
    public val cvSplitColumnNames: Output<List<String>>? = null,
    public val featurizationSettings: Output<TableVerticalFeaturizationSettingsArgs>? = null,
    public val forecastingSettings: Output<ForecastingSettingsArgs>? = null,
    public val limitSettings: Output<TableVerticalLimitSettingsArgs>? = null,
    public val logVerbosity: Output<Either<String, LogVerbosity>>? = null,
    public val nCrossValidations:
    Output<Either<AutoNCrossValidationsArgs, CustomNCrossValidationsArgs>>? = null,
    public val primaryMetric: Output<Either<String, ForecastingPrimaryMetrics>>? = null,
    public val targetColumnName: Output<String>? = null,
    public val taskType: Output<String>,
    public val testData: Output<MLTableJobInputArgs>? = null,
    public val testDataSize: Output<Double>? = null,
    public val trainingData: Output<MLTableJobInputArgs>,
    public val trainingSettings: Output<ForecastingTrainingSettingsArgs>? = null,
    public val validationData: Output<MLTableJobInputArgs>? = null,
    public val validationDataSize: Output<Double>? = null,
    public val weightColumnName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.machinelearningservices.inputs.ForecastingArgs> {
    override fun toJava(): com.pulumi.azurenative.machinelearningservices.inputs.ForecastingArgs =
        com.pulumi.azurenative.machinelearningservices.inputs.ForecastingArgs.builder()
            .cvSplitColumnNames(cvSplitColumnNames?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .featurizationSettings(
                featurizationSettings?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .forecastingSettings(
                forecastingSettings?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .limitSettings(limitSettings?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .logVerbosity(
                logVerbosity?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .nCrossValidations(
                nCrossValidations?.applyValue({ args0 ->
                    args0.transform({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    }, { args0 -> args0.let({ args0 -> args0.toJava() }) })
                }),
            )
            .primaryMetric(
                primaryMetric?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .targetColumnName(targetColumnName?.applyValue({ args0 -> args0 }))
            .taskType(taskType.applyValue({ args0 -> args0 }))
            .testData(testData?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .testDataSize(testDataSize?.applyValue({ args0 -> args0 }))
            .trainingData(trainingData.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .trainingSettings(trainingSettings?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .validationData(validationData?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .validationDataSize(validationDataSize?.applyValue({ args0 -> args0 }))
            .weightColumnName(weightColumnName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ForecastingArgs].
 */
@PulumiTagMarker
public class ForecastingArgsBuilder internal constructor() {
    private var cvSplitColumnNames: Output<List<String>>? = null

    private var featurizationSettings: Output<TableVerticalFeaturizationSettingsArgs>? = null

    private var forecastingSettings: Output<ForecastingSettingsArgs>? = null

    private var limitSettings: Output<TableVerticalLimitSettingsArgs>? = null

    private var logVerbosity: Output<Either<String, LogVerbosity>>? = null

    private var nCrossValidations:
        Output<Either<AutoNCrossValidationsArgs, CustomNCrossValidationsArgs>>? = null

    private var primaryMetric: Output<Either<String, ForecastingPrimaryMetrics>>? = null

    private var targetColumnName: Output<String>? = null

    private var taskType: Output<String>? = null

    private var testData: Output<MLTableJobInputArgs>? = null

    private var testDataSize: Output<Double>? = null

    private var trainingData: Output<MLTableJobInputArgs>? = null

    private var trainingSettings: Output<ForecastingTrainingSettingsArgs>? = null

    private var validationData: Output<MLTableJobInputArgs>? = null

    private var validationDataSize: Output<Double>? = null

    private var weightColumnName: Output<String>? = null

    /**
     * @param value Columns to use for CVSplit data.
     */
    @JvmName("smtkggnayhrimqbe")
    public suspend fun cvSplitColumnNames(`value`: Output<List<String>>) {
        this.cvSplitColumnNames = value
    }

    @JvmName("ogusvvgxrrgydfyy")
    public suspend fun cvSplitColumnNames(vararg values: Output<String>) {
        this.cvSplitColumnNames = Output.all(values.asList())
    }

    /**
     * @param values Columns to use for CVSplit data.
     */
    @JvmName("umnocrfixephvpya")
    public suspend fun cvSplitColumnNames(values: List<Output<String>>) {
        this.cvSplitColumnNames = Output.all(values)
    }

    /**
     * @param value Featurization inputs needed for AutoML job.
     */
    @JvmName("wwwttidppnwbnaan")
    public suspend
    fun featurizationSettings(`value`: Output<TableVerticalFeaturizationSettingsArgs>) {
        this.featurizationSettings = value
    }

    /**
     * @param value Forecasting task specific inputs.
     */
    @JvmName("wpthrkudnfcnhctk")
    public suspend fun forecastingSettings(`value`: Output<ForecastingSettingsArgs>) {
        this.forecastingSettings = value
    }

    /**
     * @param value Execution constraints for AutoMLJob.
     */
    @JvmName("uulawdjqveayyktv")
    public suspend fun limitSettings(`value`: Output<TableVerticalLimitSettingsArgs>) {
        this.limitSettings = value
    }

    /**
     * @param value Log verbosity for the job.
     */
    @JvmName("auxqxcykiulsxelt")
    public suspend fun logVerbosity(`value`: Output<Either<String, LogVerbosity>>) {
        this.logVerbosity = value
    }

    /**
     * @param value Number of cross validation folds to be applied on training dataset
     * when validation dataset is not provided.
     */
    @JvmName("jovuauabsvvqqnth")
    public suspend
    fun nCrossValidations(`value`: Output<Either<AutoNCrossValidationsArgs, CustomNCrossValidationsArgs>>) {
        this.nCrossValidations = value
    }

    /**
     * @param value Primary metric for forecasting task.
     */
    @JvmName("cniebmylhjsiayik")
    public suspend fun primaryMetric(`value`: Output<Either<String, ForecastingPrimaryMetrics>>) {
        this.primaryMetric = value
    }

    /**
     * @param value Target column name: This is prediction values column.
     * Also known as label column name in context of classification tasks.
     */
    @JvmName("ohqucaypihbgajks")
    public suspend fun targetColumnName(`value`: Output<String>) {
        this.targetColumnName = value
    }

    /**
     * @param value AutoMLJob Task type.
     * Expected value is 'Forecasting'.
     */
    @JvmName("sslhwkshwwhfxnyn")
    public suspend fun taskType(`value`: Output<String>) {
        this.taskType = value
    }

    /**
     * @param value Test data input.
     */
    @JvmName("brnulgtutafmoavd")
    public suspend fun testData(`value`: Output<MLTableJobInputArgs>) {
        this.testData = value
    }

    /**
     * @param value The fraction of test dataset that needs to be set aside for validation purpose.
     * Values between (0.0 , 1.0)
     * Applied when validation dataset is not provided.
     */
    @JvmName("clhyfucvlcfvhgnd")
    public suspend fun testDataSize(`value`: Output<Double>) {
        this.testDataSize = value
    }

    /**
     * @param value [Required] Training data input.
     */
    @JvmName("lvaqqboytsxyfpnm")
    public suspend fun trainingData(`value`: Output<MLTableJobInputArgs>) {
        this.trainingData = value
    }

    /**
     * @param value Inputs for training phase for an AutoML Job.
     */
    @JvmName("gtpkvfniydwrrwec")
    public suspend fun trainingSettings(`value`: Output<ForecastingTrainingSettingsArgs>) {
        this.trainingSettings = value
    }

    /**
     * @param value Validation data inputs.
     */
    @JvmName("kmpksaybqsknqong")
    public suspend fun validationData(`value`: Output<MLTableJobInputArgs>) {
        this.validationData = value
    }

    /**
     * @param value The fraction of training dataset that needs to be set aside for validation purpose.
     * Values between (0.0 , 1.0)
     * Applied when validation dataset is not provided.
     */
    @JvmName("extyrrrbwoyvlkgs")
    public suspend fun validationDataSize(`value`: Output<Double>) {
        this.validationDataSize = value
    }

    /**
     * @param value The name of the sample weight column. Automated ML supports a weighted column as an input, causing rows in the data to be weighted up or down.
     */
    @JvmName("vipgluqvqryuwubg")
    public suspend fun weightColumnName(`value`: Output<String>) {
        this.weightColumnName = value
    }

    /**
     * @param value Columns to use for CVSplit data.
     */
    @JvmName("ytyicctvijisfyki")
    public suspend fun cvSplitColumnNames(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.cvSplitColumnNames = mapped
    }

    /**
     * @param values Columns to use for CVSplit data.
     */
    @JvmName("swigxefnopmfjjqd")
    public suspend fun cvSplitColumnNames(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.cvSplitColumnNames = mapped
    }

    /**
     * @param value Featurization inputs needed for AutoML job.
     */
    @JvmName("ugwfhhordtgbhaxo")
    public suspend fun featurizationSettings(`value`: TableVerticalFeaturizationSettingsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.featurizationSettings = mapped
    }

    /**
     * @param argument Featurization inputs needed for AutoML job.
     */
    @JvmName("nxdtkueasjkrxwme")
    public suspend
    fun featurizationSettings(argument: suspend TableVerticalFeaturizationSettingsArgsBuilder.() -> Unit) {
        val toBeMapped = TableVerticalFeaturizationSettingsArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.featurizationSettings = mapped
    }

    /**
     * @param value Forecasting task specific inputs.
     */
    @JvmName("katvgjkriftaglwn")
    public suspend fun forecastingSettings(`value`: ForecastingSettingsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.forecastingSettings = mapped
    }

    /**
     * @param argument Forecasting task specific inputs.
     */
    @JvmName("asyhdtjeydesuxvg")
    public suspend
    fun forecastingSettings(argument: suspend ForecastingSettingsArgsBuilder.() -> Unit) {
        val toBeMapped = ForecastingSettingsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.forecastingSettings = mapped
    }

    /**
     * @param value Execution constraints for AutoMLJob.
     */
    @JvmName("xmbkaqpcrjxxefrv")
    public suspend fun limitSettings(`value`: TableVerticalLimitSettingsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.limitSettings = mapped
    }

    /**
     * @param argument Execution constraints for AutoMLJob.
     */
    @JvmName("gwxfnqhlgsdwvmnp")
    public suspend
    fun limitSettings(argument: suspend TableVerticalLimitSettingsArgsBuilder.() -> Unit) {
        val toBeMapped = TableVerticalLimitSettingsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.limitSettings = mapped
    }

    /**
     * @param value Log verbosity for the job.
     */
    @JvmName("rwnwspvtomacgxrr")
    public suspend fun logVerbosity(`value`: Either<String, LogVerbosity>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.logVerbosity = mapped
    }

    /**
     * @param value Log verbosity for the job.
     */
    @JvmName("limemdywdemiekgn")
    public fun logVerbosity(`value`: String) {
        val toBeMapped = Either.ofLeft<String, LogVerbosity>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.logVerbosity = mapped
    }

    /**
     * @param value Log verbosity for the job.
     */
    @JvmName("jkamysedkwxtmkiq")
    public fun logVerbosity(`value`: LogVerbosity) {
        val toBeMapped = Either.ofRight<String, LogVerbosity>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.logVerbosity = mapped
    }

    /**
     * @param value Number of cross validation folds to be applied on training dataset
     * when validation dataset is not provided.
     */
    @JvmName("hykndmjfnrrfqjoj")
    public suspend
    fun nCrossValidations(`value`: Either<AutoNCrossValidationsArgs, CustomNCrossValidationsArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.nCrossValidations = mapped
    }

    /**
     * @param value Number of cross validation folds to be applied on training dataset
     * when validation dataset is not provided.
     */
    @JvmName("bbinmgdwshsxlmpf")
    public fun nCrossValidations(`value`: AutoNCrossValidationsArgs) {
        val toBeMapped = Either.ofLeft<AutoNCrossValidationsArgs, CustomNCrossValidationsArgs>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.nCrossValidations = mapped
    }

    /**
     * @param value Number of cross validation folds to be applied on training dataset
     * when validation dataset is not provided.
     */
    @JvmName("clnwwnlcigtchosi")
    public fun nCrossValidations(`value`: CustomNCrossValidationsArgs) {
        val toBeMapped = Either.ofRight<AutoNCrossValidationsArgs, CustomNCrossValidationsArgs>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.nCrossValidations = mapped
    }

    /**
     * @param value Primary metric for forecasting task.
     */
    @JvmName("ipglufatshkrshvw")
    public suspend fun primaryMetric(`value`: Either<String, ForecastingPrimaryMetrics>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.primaryMetric = mapped
    }

    /**
     * @param value Primary metric for forecasting task.
     */
    @JvmName("vlyokipnnvyypbkl")
    public fun primaryMetric(`value`: String) {
        val toBeMapped = Either.ofLeft<String, ForecastingPrimaryMetrics>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.primaryMetric = mapped
    }

    /**
     * @param value Primary metric for forecasting task.
     */
    @JvmName("xolxbmbqwntpyitv")
    public fun primaryMetric(`value`: ForecastingPrimaryMetrics) {
        val toBeMapped = Either.ofRight<String, ForecastingPrimaryMetrics>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.primaryMetric = mapped
    }

    /**
     * @param value Target column name: This is prediction values column.
     * Also known as label column name in context of classification tasks.
     */
    @JvmName("btyyxcrytvvnmxub")
    public suspend fun targetColumnName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.targetColumnName = mapped
    }

    /**
     * @param value AutoMLJob Task type.
     * Expected value is 'Forecasting'.
     */
    @JvmName("fkulrabnutrmabng")
    public suspend fun taskType(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.taskType = mapped
    }

    /**
     * @param value Test data input.
     */
    @JvmName("waskpoyxgkwkbogv")
    public suspend fun testData(`value`: MLTableJobInputArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.testData = mapped
    }

    /**
     * @param argument Test data input.
     */
    @JvmName("rqwrivrwvhgjlupw")
    public suspend fun testData(argument: suspend MLTableJobInputArgsBuilder.() -> Unit) {
        val toBeMapped = MLTableJobInputArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.testData = mapped
    }

    /**
     * @param value The fraction of test dataset that needs to be set aside for validation purpose.
     * Values between (0.0 , 1.0)
     * Applied when validation dataset is not provided.
     */
    @JvmName("veappresnmkhkapo")
    public suspend fun testDataSize(`value`: Double?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.testDataSize = mapped
    }

    /**
     * @param value [Required] Training data input.
     */
    @JvmName("cmhapvqcxyhwfere")
    public suspend fun trainingData(`value`: MLTableJobInputArgs) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.trainingData = mapped
    }

    /**
     * @param argument [Required] Training data input.
     */
    @JvmName("htpicffknujdxear")
    public suspend fun trainingData(argument: suspend MLTableJobInputArgsBuilder.() -> Unit) {
        val toBeMapped = MLTableJobInputArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.trainingData = mapped
    }

    /**
     * @param value Inputs for training phase for an AutoML Job.
     */
    @JvmName("wbpdnchjajfqmcal")
    public suspend fun trainingSettings(`value`: ForecastingTrainingSettingsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.trainingSettings = mapped
    }

    /**
     * @param argument Inputs for training phase for an AutoML Job.
     */
    @JvmName("xournmobxnsjsjmr")
    public suspend
    fun trainingSettings(argument: suspend ForecastingTrainingSettingsArgsBuilder.() -> Unit) {
        val toBeMapped = ForecastingTrainingSettingsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.trainingSettings = mapped
    }

    /**
     * @param value Validation data inputs.
     */
    @JvmName("fdfrrhygaafxncop")
    public suspend fun validationData(`value`: MLTableJobInputArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.validationData = mapped
    }

    /**
     * @param argument Validation data inputs.
     */
    @JvmName("gmlkdpksyohhkgxv")
    public suspend fun validationData(argument: suspend MLTableJobInputArgsBuilder.() -> Unit) {
        val toBeMapped = MLTableJobInputArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.validationData = mapped
    }

    /**
     * @param value The fraction of training dataset that needs to be set aside for validation purpose.
     * Values between (0.0 , 1.0)
     * Applied when validation dataset is not provided.
     */
    @JvmName("isawlegwqqkrqcsf")
    public suspend fun validationDataSize(`value`: Double?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.validationDataSize = mapped
    }

    /**
     * @param value The name of the sample weight column. Automated ML supports a weighted column as an input, causing rows in the data to be weighted up or down.
     */
    @JvmName("ffcbyeiwkddgnwrq")
    public suspend fun weightColumnName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.weightColumnName = mapped
    }

    internal fun build(): ForecastingArgs = ForecastingArgs(
        cvSplitColumnNames = cvSplitColumnNames,
        featurizationSettings = featurizationSettings,
        forecastingSettings = forecastingSettings,
        limitSettings = limitSettings,
        logVerbosity = logVerbosity,
        nCrossValidations = nCrossValidations,
        primaryMetric = primaryMetric,
        targetColumnName = targetColumnName,
        taskType = taskType ?: throw PulumiNullFieldException("taskType"),
        testData = testData,
        testDataSize = testDataSize,
        trainingData = trainingData ?: throw PulumiNullFieldException("trainingData"),
        trainingSettings = trainingSettings,
        validationData = validationData,
        validationDataSize = validationDataSize,
        weightColumnName = weightColumnName,
    )
}
