@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.machinelearningservices.kotlin.inputs

import com.pulumi.azurenative.machinelearningservices.inputs.GetDatastorePlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property name Datastore name.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property workspaceName Name of Azure Machine Learning workspace.
 */
public data class GetDatastorePlainArgs(
    public val name: String,
    public val resourceGroupName: String,
    public val workspaceName: String,
) : ConvertibleToJava<com.pulumi.azurenative.machinelearningservices.inputs.GetDatastorePlainArgs> {
    override fun toJava(): com.pulumi.azurenative.machinelearningservices.inputs.GetDatastorePlainArgs =
        com.pulumi.azurenative.machinelearningservices.inputs.GetDatastorePlainArgs.builder()
            .name(name.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
            .workspaceName(workspaceName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetDatastorePlainArgs].
 */
@PulumiTagMarker
public class GetDatastorePlainArgsBuilder internal constructor() {
    private var name: String? = null

    private var resourceGroupName: String? = null

    private var workspaceName: String? = null

    /**
     * @param value Datastore name.
     */
    @JvmName("suoutyahigdyawwv")
    public suspend fun name(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.name = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("qfqpwcbyjivnikir")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Name of Azure Machine Learning workspace.
     */
    @JvmName("awpehkqrqjcvfkun")
    public suspend fun workspaceName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.workspaceName = mapped
    }

    internal fun build(): GetDatastorePlainArgs = GetDatastorePlainArgs(
        name = name ?: throw PulumiNullFieldException("name"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
        workspaceName = workspaceName ?: throw PulumiNullFieldException("workspaceName"),
    )
}
