@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.machinelearningservices.kotlin.inputs

import com.pulumi.azurenative.machinelearningservices.inputs.GetFeaturestoreEntityVersionPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property name Container name. This is case-sensitive.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property version Version identifier. This is case-sensitive.
 * @property workspaceName Name of Azure Machine Learning workspace.
 */
public data class GetFeaturestoreEntityVersionPlainArgs(
    public val name: String,
    public val resourceGroupName: String,
    public val version: String,
    public val workspaceName: String,
) :
    ConvertibleToJava<com.pulumi.azurenative.machinelearningservices.inputs.GetFeaturestoreEntityVersionPlainArgs> {
    override fun toJava():
        com.pulumi.azurenative.machinelearningservices.inputs.GetFeaturestoreEntityVersionPlainArgs =
        com.pulumi.azurenative.machinelearningservices.inputs.GetFeaturestoreEntityVersionPlainArgs.builder()
            .name(name.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
            .version(version.let({ args0 -> args0 }))
            .workspaceName(workspaceName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetFeaturestoreEntityVersionPlainArgs].
 */
@PulumiTagMarker
public class GetFeaturestoreEntityVersionPlainArgsBuilder internal constructor() {
    private var name: String? = null

    private var resourceGroupName: String? = null

    private var version: String? = null

    private var workspaceName: String? = null

    /**
     * @param value Container name. This is case-sensitive.
     */
    @JvmName("tgelncsmpyjpwwxd")
    public suspend fun name(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.name = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("jvlbkeniknxpgvnl")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Version identifier. This is case-sensitive.
     */
    @JvmName("ivpsedvdoobqmwpc")
    public suspend fun version(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.version = mapped
    }

    /**
     * @param value Name of Azure Machine Learning workspace.
     */
    @JvmName("ufumvhfmisyyytxa")
    public suspend fun workspaceName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.workspaceName = mapped
    }

    internal fun build(): GetFeaturestoreEntityVersionPlainArgs =
        GetFeaturestoreEntityVersionPlainArgs(
            name = name ?: throw PulumiNullFieldException("name"),
            resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
            version = version ?: throw PulumiNullFieldException("version"),
            workspaceName = workspaceName ?: throw PulumiNullFieldException("workspaceName"),
        )
}
