@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.machinelearningservices.kotlin.inputs

import com.pulumi.azurenative.machinelearningservices.inputs.GetLinkedServicePlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property linkName Friendly name of the linked workspace
 * @property resourceGroupName Name of the resource group in which workspace is located.
 * @property workspaceName Name of Azure Machine Learning workspace.
 */
public data class GetLinkedServicePlainArgs(
    public val linkName: String,
    public val resourceGroupName: String,
    public val workspaceName: String,
) :
    ConvertibleToJava<com.pulumi.azurenative.machinelearningservices.inputs.GetLinkedServicePlainArgs> {
    override fun toJava():
        com.pulumi.azurenative.machinelearningservices.inputs.GetLinkedServicePlainArgs =
        com.pulumi.azurenative.machinelearningservices.inputs.GetLinkedServicePlainArgs.builder()
            .linkName(linkName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
            .workspaceName(workspaceName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetLinkedServicePlainArgs].
 */
@PulumiTagMarker
public class GetLinkedServicePlainArgsBuilder internal constructor() {
    private var linkName: String? = null

    private var resourceGroupName: String? = null

    private var workspaceName: String? = null

    /**
     * @param value Friendly name of the linked workspace
     */
    @JvmName("vpcwysdjdhvjqmin")
    public suspend fun linkName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.linkName = mapped
    }

    /**
     * @param value Name of the resource group in which workspace is located.
     */
    @JvmName("rydktiwoaicrpuje")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Name of Azure Machine Learning workspace.
     */
    @JvmName("pyutmgalbfxefema")
    public suspend fun workspaceName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.workspaceName = mapped
    }

    internal fun build(): GetLinkedServicePlainArgs = GetLinkedServicePlainArgs(
        linkName = linkName ?: throw PulumiNullFieldException("linkName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
        workspaceName = workspaceName ?: throw PulumiNullFieldException("workspaceName"),
    )
}
