@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.machinelearningservices.kotlin.inputs

import com.pulumi.azurenative.machinelearningservices.inputs.GetManagedNetworkSettingsRulePlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property ruleName Name of the workspace managed network outbound rule
 * @property workspaceName Name of Azure Machine Learning workspace.
 */
public data class GetManagedNetworkSettingsRulePlainArgs(
    public val resourceGroupName: String,
    public val ruleName: String,
    public val workspaceName: String,
) :
    ConvertibleToJava<com.pulumi.azurenative.machinelearningservices.inputs.GetManagedNetworkSettingsRulePlainArgs> {
    override fun toJava():
        com.pulumi.azurenative.machinelearningservices.inputs.GetManagedNetworkSettingsRulePlainArgs =
        com.pulumi.azurenative.machinelearningservices.inputs.GetManagedNetworkSettingsRulePlainArgs.builder()
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
            .ruleName(ruleName.let({ args0 -> args0 }))
            .workspaceName(workspaceName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetManagedNetworkSettingsRulePlainArgs].
 */
@PulumiTagMarker
public class GetManagedNetworkSettingsRulePlainArgsBuilder internal constructor() {
    private var resourceGroupName: String? = null

    private var ruleName: String? = null

    private var workspaceName: String? = null

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("fpbesfnawguthtmf")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Name of the workspace managed network outbound rule
     */
    @JvmName("qguxqkhdvopqsnry")
    public suspend fun ruleName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.ruleName = mapped
    }

    /**
     * @param value Name of Azure Machine Learning workspace.
     */
    @JvmName("phdosgniyhfrddsq")
    public suspend fun workspaceName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.workspaceName = mapped
    }

    internal fun build(): GetManagedNetworkSettingsRulePlainArgs =
        GetManagedNetworkSettingsRulePlainArgs(
            resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
            ruleName = ruleName ?: throw PulumiNullFieldException("ruleName"),
            workspaceName = workspaceName ?: throw PulumiNullFieldException("workspaceName"),
        )
}
