@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.machinelearningservices.kotlin.inputs

import com.pulumi.azurenative.machinelearningservices.inputs.GetRegistryCodeVersionPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property codeName Container name.
 * @property registryName Name of Azure Machine Learning registry. This is case-insensitive
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property version Version identifier.
 */
public data class GetRegistryCodeVersionPlainArgs(
    public val codeName: String,
    public val registryName: String,
    public val resourceGroupName: String,
    public val version: String,
) :
    ConvertibleToJava<com.pulumi.azurenative.machinelearningservices.inputs.GetRegistryCodeVersionPlainArgs> {
    override fun toJava():
        com.pulumi.azurenative.machinelearningservices.inputs.GetRegistryCodeVersionPlainArgs =
        com.pulumi.azurenative.machinelearningservices.inputs.GetRegistryCodeVersionPlainArgs.builder()
            .codeName(codeName.let({ args0 -> args0 }))
            .registryName(registryName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
            .version(version.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetRegistryCodeVersionPlainArgs].
 */
@PulumiTagMarker
public class GetRegistryCodeVersionPlainArgsBuilder internal constructor() {
    private var codeName: String? = null

    private var registryName: String? = null

    private var resourceGroupName: String? = null

    private var version: String? = null

    /**
     * @param value Container name.
     */
    @JvmName("bekhtnxalcxtnbly")
    public suspend fun codeName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.codeName = mapped
    }

    /**
     * @param value Name of Azure Machine Learning registry. This is case-insensitive
     */
    @JvmName("haafchbempcswhho")
    public suspend fun registryName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.registryName = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("fkxvcfgecpivlrwq")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Version identifier.
     */
    @JvmName("dftdvcqdnvwhytbh")
    public suspend fun version(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.version = mapped
    }

    internal fun build(): GetRegistryCodeVersionPlainArgs = GetRegistryCodeVersionPlainArgs(
        codeName = codeName ?: throw PulumiNullFieldException("codeName"),
        registryName = registryName ?: throw PulumiNullFieldException("registryName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
        version = version ?: throw PulumiNullFieldException("version"),
    )
}
