@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.machinelearningservices.kotlin.inputs

import com.pulumi.azurenative.machinelearningservices.inputs.HDInsightPropertiesArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * HDInsight compute properties
 * @property address Public IP address of the master node of the cluster.
 * @property administratorAccount Admin credentials for master node of the cluster
 * @property sshPort Port open for ssh connections on the master node of the cluster.
 */
public data class HDInsightPropertiesArgs(
    public val address: Output<String>? = null,
    public val administratorAccount: Output<VirtualMachineSshCredentialsArgs>? = null,
    public val sshPort: Output<Int>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.machinelearningservices.inputs.HDInsightPropertiesArgs> {
    override fun toJava():
        com.pulumi.azurenative.machinelearningservices.inputs.HDInsightPropertiesArgs =
        com.pulumi.azurenative.machinelearningservices.inputs.HDInsightPropertiesArgs.builder()
            .address(address?.applyValue({ args0 -> args0 }))
            .administratorAccount(
                administratorAccount?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .sshPort(sshPort?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [HDInsightPropertiesArgs].
 */
@PulumiTagMarker
public class HDInsightPropertiesArgsBuilder internal constructor() {
    private var address: Output<String>? = null

    private var administratorAccount: Output<VirtualMachineSshCredentialsArgs>? = null

    private var sshPort: Output<Int>? = null

    /**
     * @param value Public IP address of the master node of the cluster.
     */
    @JvmName("tftekvuxwthrwief")
    public suspend fun address(`value`: Output<String>) {
        this.address = value
    }

    /**
     * @param value Admin credentials for master node of the cluster
     */
    @JvmName("illqgtbxvofpbcip")
    public suspend fun administratorAccount(`value`: Output<VirtualMachineSshCredentialsArgs>) {
        this.administratorAccount = value
    }

    /**
     * @param value Port open for ssh connections on the master node of the cluster.
     */
    @JvmName("doxjelaaujomlkhk")
    public suspend fun sshPort(`value`: Output<Int>) {
        this.sshPort = value
    }

    /**
     * @param value Public IP address of the master node of the cluster.
     */
    @JvmName("tqukiqgpcknuacuc")
    public suspend fun address(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.address = mapped
    }

    /**
     * @param value Admin credentials for master node of the cluster
     */
    @JvmName("sxleghidelkvjind")
    public suspend fun administratorAccount(`value`: VirtualMachineSshCredentialsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.administratorAccount = mapped
    }

    /**
     * @param argument Admin credentials for master node of the cluster
     */
    @JvmName("jsrvdmmuywrnkevl")
    public suspend
    fun administratorAccount(argument: suspend VirtualMachineSshCredentialsArgsBuilder.() -> Unit) {
        val toBeMapped = VirtualMachineSshCredentialsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.administratorAccount = mapped
    }

    /**
     * @param value Port open for ssh connections on the master node of the cluster.
     */
    @JvmName("gxgitvdymlwnghgb")
    public suspend fun sshPort(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sshPort = mapped
    }

    internal fun build(): HDInsightPropertiesArgs = HDInsightPropertiesArgs(
        address = address,
        administratorAccount = administratorAccount,
        sshPort = sshPort,
    )
}
