@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.machinelearningservices.kotlin.inputs

import com.pulumi.azurenative.machinelearningservices.inputs.ImageModelSettingsClassificationArgs.builder
import com.pulumi.azurenative.machinelearningservices.kotlin.enums.LearningRateScheduler
import com.pulumi.azurenative.machinelearningservices.kotlin.enums.StochasticOptimizer
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.Double
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Settings used for training the model.
 * For more information on the available settings please visit the official documentation:
 * https://docs.microsoft.com/en-us/azure/machine-learning/how-to-auto-train-image-models.
 * @property advancedSettings Settings for advanced scenarios.
 * @property amsGradient Enable AMSGrad when optimizer is 'adam' or 'adamw'.
 * @property augmentations Settings for using Augmentations.
 * @property beta1 Value of 'beta1' when optimizer is 'adam' or 'adamw'. Must be a float in the range [0, 1].
 * @property beta2 Value of 'beta2' when optimizer is 'adam' or 'adamw'. Must be a float in the range [0, 1].
 * @property checkpointFrequency Frequency to store model checkpoints. Must be a positive integer.
 * @property checkpointModel The pretrained checkpoint model for incremental training.
 * @property checkpointRunId The id of a previous run that has a pretrained checkpoint for incremental training.
 * @property distributed Whether to use distributed training.
 * @property earlyStopping Enable early stopping logic during training.
 * @property earlyStoppingDelay Minimum number of epochs or validation evaluations to wait before primary metric improvement
 * is tracked for early stopping. Must be a positive integer.
 * @property earlyStoppingPatience Minimum number of epochs or validation evaluations with no primary metric improvement before
 * the run is stopped. Must be a positive integer.
 * @property enableOnnxNormalization Enable normalization when exporting ONNX model.
 * @property evaluationFrequency Frequency to evaluate validation dataset to get metric scores. Must be a positive integer.
 * @property gradientAccumulationStep Gradient accumulation means running a configured number of "GradAccumulationStep" steps without
 * updating the model weights while accumulating the gradients of those steps, and then using
 * the accumulated gradients to compute the weight updates. Must be a positive integer.
 * @property layersToFreeze Number of layers to freeze for the model. Must be a positive integer.
 * For instance, passing 2 as value for 'seresnext' means
 * freezing layer0 and layer1. For a full list of models supported and details on layer freeze, please
 * see: https://docs.microsoft.com/en-us/azure/machine-learning/how-to-auto-train-image-models.
 * @property learningRate Initial learning rate. Must be a float in the range [0, 1].
 * @property learningRateScheduler Type of learning rate scheduler. Must be 'warmup_cosine' or 'step'.
 * @property modelName Name of the model to use for training.
 * For more information on the available models please visit the official documentation:
 * https://docs.microsoft.com/en-us/azure/machine-learning/how-to-auto-train-image-models.
 * @property momentum Value of momentum when optimizer is 'sgd'. Must be a float in the range [0, 1].
 * @property nesterov Enable nesterov when optimizer is 'sgd'.
 * @property numberOfEpochs Number of training epochs. Must be a positive integer.
 * @property numberOfWorkers Number of data loader workers. Must be a non-negative integer.
 * @property optimizer Type of optimizer.
 * @property randomSeed Random seed to be used when using deterministic training.
 * @property stepLRGamma Value of gamma when learning rate scheduler is 'step'. Must be a float in the range [0, 1].
 * @property stepLRStepSize Value of step size when learning rate scheduler is 'step'. Must be a positive integer.
 * @property trainingBatchSize Training batch size. Must be a positive integer.
 * @property trainingCropSize Image crop size that is input to the neural network for the training dataset. Must be a positive integer.
 * @property validationBatchSize Validation batch size. Must be a positive integer.
 * @property validationCropSize Image crop size that is input to the neural network for the validation dataset. Must be a positive integer.
 * @property validationResizeSize Image size to which to resize before cropping for validation dataset. Must be a positive integer.
 * @property warmupCosineLRCycles Value of cosine cycle when learning rate scheduler is 'warmup_cosine'. Must be a float in the range [0, 1].
 * @property warmupCosineLRWarmupEpochs Value of warmup epochs when learning rate scheduler is 'warmup_cosine'. Must be a positive integer.
 * @property weightDecay Value of weight decay when optimizer is 'sgd', 'adam', or 'adamw'. Must be a float in the range[0, 1].
 * @property weightedLoss Weighted loss. The accepted values are 0 for no weighted loss.
 * 1 for weighted loss with sqrt.(class_weights). 2 for weighted loss with class_weights. Must be 0 or 1 or 2.
 */
public data class ImageModelSettingsClassificationArgs(
    public val advancedSettings: Output<String>? = null,
    public val amsGradient: Output<Boolean>? = null,
    public val augmentations: Output<String>? = null,
    public val beta1: Output<Double>? = null,
    public val beta2: Output<Double>? = null,
    public val checkpointFrequency: Output<Int>? = null,
    public val checkpointModel: Output<MLFlowModelJobInputArgs>? = null,
    public val checkpointRunId: Output<String>? = null,
    public val distributed: Output<Boolean>? = null,
    public val earlyStopping: Output<Boolean>? = null,
    public val earlyStoppingDelay: Output<Int>? = null,
    public val earlyStoppingPatience: Output<Int>? = null,
    public val enableOnnxNormalization: Output<Boolean>? = null,
    public val evaluationFrequency: Output<Int>? = null,
    public val gradientAccumulationStep: Output<Int>? = null,
    public val layersToFreeze: Output<Int>? = null,
    public val learningRate: Output<Double>? = null,
    public val learningRateScheduler: Output<Either<String, LearningRateScheduler>>? = null,
    public val modelName: Output<String>? = null,
    public val momentum: Output<Double>? = null,
    public val nesterov: Output<Boolean>? = null,
    public val numberOfEpochs: Output<Int>? = null,
    public val numberOfWorkers: Output<Int>? = null,
    public val optimizer: Output<Either<String, StochasticOptimizer>>? = null,
    public val randomSeed: Output<Int>? = null,
    public val stepLRGamma: Output<Double>? = null,
    public val stepLRStepSize: Output<Int>? = null,
    public val trainingBatchSize: Output<Int>? = null,
    public val trainingCropSize: Output<Int>? = null,
    public val validationBatchSize: Output<Int>? = null,
    public val validationCropSize: Output<Int>? = null,
    public val validationResizeSize: Output<Int>? = null,
    public val warmupCosineLRCycles: Output<Double>? = null,
    public val warmupCosineLRWarmupEpochs: Output<Int>? = null,
    public val weightDecay: Output<Double>? = null,
    public val weightedLoss: Output<Int>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.machinelearningservices.inputs.ImageModelSettingsClassificationArgs> {
    override fun toJava():
        com.pulumi.azurenative.machinelearningservices.inputs.ImageModelSettingsClassificationArgs =
        com.pulumi.azurenative.machinelearningservices.inputs.ImageModelSettingsClassificationArgs.builder()
            .advancedSettings(advancedSettings?.applyValue({ args0 -> args0 }))
            .amsGradient(amsGradient?.applyValue({ args0 -> args0 }))
            .augmentations(augmentations?.applyValue({ args0 -> args0 }))
            .beta1(beta1?.applyValue({ args0 -> args0 }))
            .beta2(beta2?.applyValue({ args0 -> args0 }))
            .checkpointFrequency(checkpointFrequency?.applyValue({ args0 -> args0 }))
            .checkpointModel(checkpointModel?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .checkpointRunId(checkpointRunId?.applyValue({ args0 -> args0 }))
            .distributed(distributed?.applyValue({ args0 -> args0 }))
            .earlyStopping(earlyStopping?.applyValue({ args0 -> args0 }))
            .earlyStoppingDelay(earlyStoppingDelay?.applyValue({ args0 -> args0 }))
            .earlyStoppingPatience(earlyStoppingPatience?.applyValue({ args0 -> args0 }))
            .enableOnnxNormalization(enableOnnxNormalization?.applyValue({ args0 -> args0 }))
            .evaluationFrequency(evaluationFrequency?.applyValue({ args0 -> args0 }))
            .gradientAccumulationStep(gradientAccumulationStep?.applyValue({ args0 -> args0 }))
            .layersToFreeze(layersToFreeze?.applyValue({ args0 -> args0 }))
            .learningRate(learningRate?.applyValue({ args0 -> args0 }))
            .learningRateScheduler(
                learningRateScheduler?.applyValue({ args0 ->
                    args0.transform({ args0 ->
                        args0
                    }, { args0 -> args0.let({ args0 -> args0.toJava() }) })
                }),
            )
            .modelName(modelName?.applyValue({ args0 -> args0 }))
            .momentum(momentum?.applyValue({ args0 -> args0 }))
            .nesterov(nesterov?.applyValue({ args0 -> args0 }))
            .numberOfEpochs(numberOfEpochs?.applyValue({ args0 -> args0 }))
            .numberOfWorkers(numberOfWorkers?.applyValue({ args0 -> args0 }))
            .optimizer(
                optimizer?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .randomSeed(randomSeed?.applyValue({ args0 -> args0 }))
            .stepLRGamma(stepLRGamma?.applyValue({ args0 -> args0 }))
            .stepLRStepSize(stepLRStepSize?.applyValue({ args0 -> args0 }))
            .trainingBatchSize(trainingBatchSize?.applyValue({ args0 -> args0 }))
            .trainingCropSize(trainingCropSize?.applyValue({ args0 -> args0 }))
            .validationBatchSize(validationBatchSize?.applyValue({ args0 -> args0 }))
            .validationCropSize(validationCropSize?.applyValue({ args0 -> args0 }))
            .validationResizeSize(validationResizeSize?.applyValue({ args0 -> args0 }))
            .warmupCosineLRCycles(warmupCosineLRCycles?.applyValue({ args0 -> args0 }))
            .warmupCosineLRWarmupEpochs(warmupCosineLRWarmupEpochs?.applyValue({ args0 -> args0 }))
            .weightDecay(weightDecay?.applyValue({ args0 -> args0 }))
            .weightedLoss(weightedLoss?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ImageModelSettingsClassificationArgs].
 */
@PulumiTagMarker
public class ImageModelSettingsClassificationArgsBuilder internal constructor() {
    private var advancedSettings: Output<String>? = null

    private var amsGradient: Output<Boolean>? = null

    private var augmentations: Output<String>? = null

    private var beta1: Output<Double>? = null

    private var beta2: Output<Double>? = null

    private var checkpointFrequency: Output<Int>? = null

    private var checkpointModel: Output<MLFlowModelJobInputArgs>? = null

    private var checkpointRunId: Output<String>? = null

    private var distributed: Output<Boolean>? = null

    private var earlyStopping: Output<Boolean>? = null

    private var earlyStoppingDelay: Output<Int>? = null

    private var earlyStoppingPatience: Output<Int>? = null

    private var enableOnnxNormalization: Output<Boolean>? = null

    private var evaluationFrequency: Output<Int>? = null

    private var gradientAccumulationStep: Output<Int>? = null

    private var layersToFreeze: Output<Int>? = null

    private var learningRate: Output<Double>? = null

    private var learningRateScheduler: Output<Either<String, LearningRateScheduler>>? = null

    private var modelName: Output<String>? = null

    private var momentum: Output<Double>? = null

    private var nesterov: Output<Boolean>? = null

    private var numberOfEpochs: Output<Int>? = null

    private var numberOfWorkers: Output<Int>? = null

    private var optimizer: Output<Either<String, StochasticOptimizer>>? = null

    private var randomSeed: Output<Int>? = null

    private var stepLRGamma: Output<Double>? = null

    private var stepLRStepSize: Output<Int>? = null

    private var trainingBatchSize: Output<Int>? = null

    private var trainingCropSize: Output<Int>? = null

    private var validationBatchSize: Output<Int>? = null

    private var validationCropSize: Output<Int>? = null

    private var validationResizeSize: Output<Int>? = null

    private var warmupCosineLRCycles: Output<Double>? = null

    private var warmupCosineLRWarmupEpochs: Output<Int>? = null

    private var weightDecay: Output<Double>? = null

    private var weightedLoss: Output<Int>? = null

    /**
     * @param value Settings for advanced scenarios.
     */
    @JvmName("lwuqyntkvqpneith")
    public suspend fun advancedSettings(`value`: Output<String>) {
        this.advancedSettings = value
    }

    /**
     * @param value Enable AMSGrad when optimizer is 'adam' or 'adamw'.
     */
    @JvmName("esaursdspsomyokw")
    public suspend fun amsGradient(`value`: Output<Boolean>) {
        this.amsGradient = value
    }

    /**
     * @param value Settings for using Augmentations.
     */
    @JvmName("tdgxyyqadixappnn")
    public suspend fun augmentations(`value`: Output<String>) {
        this.augmentations = value
    }

    /**
     * @param value Value of 'beta1' when optimizer is 'adam' or 'adamw'. Must be a float in the range [0, 1].
     */
    @JvmName("hkvgdnncyrbgehep")
    public suspend fun beta1(`value`: Output<Double>) {
        this.beta1 = value
    }

    /**
     * @param value Value of 'beta2' when optimizer is 'adam' or 'adamw'. Must be a float in the range [0, 1].
     */
    @JvmName("thndlaugdfcssbfe")
    public suspend fun beta2(`value`: Output<Double>) {
        this.beta2 = value
    }

    /**
     * @param value Frequency to store model checkpoints. Must be a positive integer.
     */
    @JvmName("tbalxpvibvjnvyxm")
    public suspend fun checkpointFrequency(`value`: Output<Int>) {
        this.checkpointFrequency = value
    }

    /**
     * @param value The pretrained checkpoint model for incremental training.
     */
    @JvmName("fcaprroqihbuylfj")
    public suspend fun checkpointModel(`value`: Output<MLFlowModelJobInputArgs>) {
        this.checkpointModel = value
    }

    /**
     * @param value The id of a previous run that has a pretrained checkpoint for incremental training.
     */
    @JvmName("rvkdaocoklipxnpc")
    public suspend fun checkpointRunId(`value`: Output<String>) {
        this.checkpointRunId = value
    }

    /**
     * @param value Whether to use distributed training.
     */
    @JvmName("krcudjitvpnukyjo")
    public suspend fun distributed(`value`: Output<Boolean>) {
        this.distributed = value
    }

    /**
     * @param value Enable early stopping logic during training.
     */
    @JvmName("eudghuyuajiglvyf")
    public suspend fun earlyStopping(`value`: Output<Boolean>) {
        this.earlyStopping = value
    }

    /**
     * @param value Minimum number of epochs or validation evaluations to wait before primary metric improvement
     * is tracked for early stopping. Must be a positive integer.
     */
    @JvmName("tamehjaphpxeamjk")
    public suspend fun earlyStoppingDelay(`value`: Output<Int>) {
        this.earlyStoppingDelay = value
    }

    /**
     * @param value Minimum number of epochs or validation evaluations with no primary metric improvement before
     * the run is stopped. Must be a positive integer.
     */
    @JvmName("uciguarthnjowadw")
    public suspend fun earlyStoppingPatience(`value`: Output<Int>) {
        this.earlyStoppingPatience = value
    }

    /**
     * @param value Enable normalization when exporting ONNX model.
     */
    @JvmName("urblskeyspovjvcr")
    public suspend fun enableOnnxNormalization(`value`: Output<Boolean>) {
        this.enableOnnxNormalization = value
    }

    /**
     * @param value Frequency to evaluate validation dataset to get metric scores. Must be a positive integer.
     */
    @JvmName("pxrsxmmjyvnneoyb")
    public suspend fun evaluationFrequency(`value`: Output<Int>) {
        this.evaluationFrequency = value
    }

    /**
     * @param value Gradient accumulation means running a configured number of "GradAccumulationStep" steps without
     * updating the model weights while accumulating the gradients of those steps, and then using
     * the accumulated gradients to compute the weight updates. Must be a positive integer.
     */
    @JvmName("jciuqfdhedetrlhq")
    public suspend fun gradientAccumulationStep(`value`: Output<Int>) {
        this.gradientAccumulationStep = value
    }

    /**
     * @param value Number of layers to freeze for the model. Must be a positive integer.
     * For instance, passing 2 as value for 'seresnext' means
     * freezing layer0 and layer1. For a full list of models supported and details on layer freeze, please
     * see: https://docs.microsoft.com/en-us/azure/machine-learning/how-to-auto-train-image-models.
     */
    @JvmName("alrlhmuwjeesusky")
    public suspend fun layersToFreeze(`value`: Output<Int>) {
        this.layersToFreeze = value
    }

    /**
     * @param value Initial learning rate. Must be a float in the range [0, 1].
     */
    @JvmName("jfcqpgupflhcqbsd")
    public suspend fun learningRate(`value`: Output<Double>) {
        this.learningRate = value
    }

    /**
     * @param value Type of learning rate scheduler. Must be 'warmup_cosine' or 'step'.
     */
    @JvmName("kbshuhtcqjrsbxxs")
    public suspend fun learningRateScheduler(`value`: Output<Either<String, LearningRateScheduler>>) {
        this.learningRateScheduler = value
    }

    /**
     * @param value Name of the model to use for training.
     * For more information on the available models please visit the official documentation:
     * https://docs.microsoft.com/en-us/azure/machine-learning/how-to-auto-train-image-models.
     */
    @JvmName("ofruudqivmegjqrx")
    public suspend fun modelName(`value`: Output<String>) {
        this.modelName = value
    }

    /**
     * @param value Value of momentum when optimizer is 'sgd'. Must be a float in the range [0, 1].
     */
    @JvmName("iicftprmaufpofgk")
    public suspend fun momentum(`value`: Output<Double>) {
        this.momentum = value
    }

    /**
     * @param value Enable nesterov when optimizer is 'sgd'.
     */
    @JvmName("urhgdvpnwapbvvsc")
    public suspend fun nesterov(`value`: Output<Boolean>) {
        this.nesterov = value
    }

    /**
     * @param value Number of training epochs. Must be a positive integer.
     */
    @JvmName("rtgfjitbuulahnij")
    public suspend fun numberOfEpochs(`value`: Output<Int>) {
        this.numberOfEpochs = value
    }

    /**
     * @param value Number of data loader workers. Must be a non-negative integer.
     */
    @JvmName("vpuosqvwamgggvnj")
    public suspend fun numberOfWorkers(`value`: Output<Int>) {
        this.numberOfWorkers = value
    }

    /**
     * @param value Type of optimizer.
     */
    @JvmName("udcxifuhoybtbelt")
    public suspend fun optimizer(`value`: Output<Either<String, StochasticOptimizer>>) {
        this.optimizer = value
    }

    /**
     * @param value Random seed to be used when using deterministic training.
     */
    @JvmName("xtqvhpjltbqihtjt")
    public suspend fun randomSeed(`value`: Output<Int>) {
        this.randomSeed = value
    }

    /**
     * @param value Value of gamma when learning rate scheduler is 'step'. Must be a float in the range [0, 1].
     */
    @JvmName("bfrhrafkvbqaiblt")
    public suspend fun stepLRGamma(`value`: Output<Double>) {
        this.stepLRGamma = value
    }

    /**
     * @param value Value of step size when learning rate scheduler is 'step'. Must be a positive integer.
     */
    @JvmName("fjkduhdmjswgknfc")
    public suspend fun stepLRStepSize(`value`: Output<Int>) {
        this.stepLRStepSize = value
    }

    /**
     * @param value Training batch size. Must be a positive integer.
     */
    @JvmName("upslvqvnplewkjpf")
    public suspend fun trainingBatchSize(`value`: Output<Int>) {
        this.trainingBatchSize = value
    }

    /**
     * @param value Image crop size that is input to the neural network for the training dataset. Must be a positive integer.
     */
    @JvmName("vieynlwapqpjhqml")
    public suspend fun trainingCropSize(`value`: Output<Int>) {
        this.trainingCropSize = value
    }

    /**
     * @param value Validation batch size. Must be a positive integer.
     */
    @JvmName("dljjtirqepgxfvbq")
    public suspend fun validationBatchSize(`value`: Output<Int>) {
        this.validationBatchSize = value
    }

    /**
     * @param value Image crop size that is input to the neural network for the validation dataset. Must be a positive integer.
     */
    @JvmName("fpjjgapydymstrrp")
    public suspend fun validationCropSize(`value`: Output<Int>) {
        this.validationCropSize = value
    }

    /**
     * @param value Image size to which to resize before cropping for validation dataset. Must be a positive integer.
     */
    @JvmName("bsrspguhjbhptoqs")
    public suspend fun validationResizeSize(`value`: Output<Int>) {
        this.validationResizeSize = value
    }

    /**
     * @param value Value of cosine cycle when learning rate scheduler is 'warmup_cosine'. Must be a float in the range [0, 1].
     */
    @JvmName("hchubbedrvaytyqa")
    public suspend fun warmupCosineLRCycles(`value`: Output<Double>) {
        this.warmupCosineLRCycles = value
    }

    /**
     * @param value Value of warmup epochs when learning rate scheduler is 'warmup_cosine'. Must be a positive integer.
     */
    @JvmName("skpgvrdfbgkywcrg")
    public suspend fun warmupCosineLRWarmupEpochs(`value`: Output<Int>) {
        this.warmupCosineLRWarmupEpochs = value
    }

    /**
     * @param value Value of weight decay when optimizer is 'sgd', 'adam', or 'adamw'. Must be a float in the range[0, 1].
     */
    @JvmName("gimatiilfbmvkanp")
    public suspend fun weightDecay(`value`: Output<Double>) {
        this.weightDecay = value
    }

    /**
     * @param value Weighted loss. The accepted values are 0 for no weighted loss.
     * 1 for weighted loss with sqrt.(class_weights). 2 for weighted loss with class_weights. Must be 0 or 1 or 2.
     */
    @JvmName("qdhmtjoihdnlfhwf")
    public suspend fun weightedLoss(`value`: Output<Int>) {
        this.weightedLoss = value
    }

    /**
     * @param value Settings for advanced scenarios.
     */
    @JvmName("gnxnbxnnwgvtfxqu")
    public suspend fun advancedSettings(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.advancedSettings = mapped
    }

    /**
     * @param value Enable AMSGrad when optimizer is 'adam' or 'adamw'.
     */
    @JvmName("lksdwjdefpcrjopk")
    public suspend fun amsGradient(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.amsGradient = mapped
    }

    /**
     * @param value Settings for using Augmentations.
     */
    @JvmName("nsybxobdhtamhvky")
    public suspend fun augmentations(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.augmentations = mapped
    }

    /**
     * @param value Value of 'beta1' when optimizer is 'adam' or 'adamw'. Must be a float in the range [0, 1].
     */
    @JvmName("lmlcinmlotfmuevx")
    public suspend fun beta1(`value`: Double?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.beta1 = mapped
    }

    /**
     * @param value Value of 'beta2' when optimizer is 'adam' or 'adamw'. Must be a float in the range [0, 1].
     */
    @JvmName("ahbukavqcrinuufp")
    public suspend fun beta2(`value`: Double?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.beta2 = mapped
    }

    /**
     * @param value Frequency to store model checkpoints. Must be a positive integer.
     */
    @JvmName("yfplwkgupkvsnwsy")
    public suspend fun checkpointFrequency(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.checkpointFrequency = mapped
    }

    /**
     * @param value The pretrained checkpoint model for incremental training.
     */
    @JvmName("qragvkinryvqpchg")
    public suspend fun checkpointModel(`value`: MLFlowModelJobInputArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.checkpointModel = mapped
    }

    /**
     * @param argument The pretrained checkpoint model for incremental training.
     */
    @JvmName("rduxbgvrhnwriusb")
    public suspend fun checkpointModel(argument: suspend MLFlowModelJobInputArgsBuilder.() -> Unit) {
        val toBeMapped = MLFlowModelJobInputArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.checkpointModel = mapped
    }

    /**
     * @param value The id of a previous run that has a pretrained checkpoint for incremental training.
     */
    @JvmName("bldtelwjxwfgwlsk")
    public suspend fun checkpointRunId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.checkpointRunId = mapped
    }

    /**
     * @param value Whether to use distributed training.
     */
    @JvmName("yssynvlsjivqboaf")
    public suspend fun distributed(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.distributed = mapped
    }

    /**
     * @param value Enable early stopping logic during training.
     */
    @JvmName("umjppswogotrecgh")
    public suspend fun earlyStopping(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.earlyStopping = mapped
    }

    /**
     * @param value Minimum number of epochs or validation evaluations to wait before primary metric improvement
     * is tracked for early stopping. Must be a positive integer.
     */
    @JvmName("qbvhgtlwfdmjjxir")
    public suspend fun earlyStoppingDelay(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.earlyStoppingDelay = mapped
    }

    /**
     * @param value Minimum number of epochs or validation evaluations with no primary metric improvement before
     * the run is stopped. Must be a positive integer.
     */
    @JvmName("uvdkltgespowagpt")
    public suspend fun earlyStoppingPatience(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.earlyStoppingPatience = mapped
    }

    /**
     * @param value Enable normalization when exporting ONNX model.
     */
    @JvmName("hfbpysayhuqxkjij")
    public suspend fun enableOnnxNormalization(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enableOnnxNormalization = mapped
    }

    /**
     * @param value Frequency to evaluate validation dataset to get metric scores. Must be a positive integer.
     */
    @JvmName("thrvqjddawxniqln")
    public suspend fun evaluationFrequency(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.evaluationFrequency = mapped
    }

    /**
     * @param value Gradient accumulation means running a configured number of "GradAccumulationStep" steps without
     * updating the model weights while accumulating the gradients of those steps, and then using
     * the accumulated gradients to compute the weight updates. Must be a positive integer.
     */
    @JvmName("iqldkrqxwtshxshp")
    public suspend fun gradientAccumulationStep(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.gradientAccumulationStep = mapped
    }

    /**
     * @param value Number of layers to freeze for the model. Must be a positive integer.
     * For instance, passing 2 as value for 'seresnext' means
     * freezing layer0 and layer1. For a full list of models supported and details on layer freeze, please
     * see: https://docs.microsoft.com/en-us/azure/machine-learning/how-to-auto-train-image-models.
     */
    @JvmName("hpwslxdjwykeofwi")
    public suspend fun layersToFreeze(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.layersToFreeze = mapped
    }

    /**
     * @param value Initial learning rate. Must be a float in the range [0, 1].
     */
    @JvmName("tqughtxuljgublxp")
    public suspend fun learningRate(`value`: Double?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.learningRate = mapped
    }

    /**
     * @param value Type of learning rate scheduler. Must be 'warmup_cosine' or 'step'.
     */
    @JvmName("mnuqdvxxknajwjnn")
    public suspend fun learningRateScheduler(`value`: Either<String, LearningRateScheduler>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.learningRateScheduler = mapped
    }

    /**
     * @param value Type of learning rate scheduler. Must be 'warmup_cosine' or 'step'.
     */
    @JvmName("armwxnikkrsrnicv")
    public fun learningRateScheduler(`value`: String) {
        val toBeMapped = Either.ofLeft<String, LearningRateScheduler>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.learningRateScheduler = mapped
    }

    /**
     * @param value Type of learning rate scheduler. Must be 'warmup_cosine' or 'step'.
     */
    @JvmName("xvcpflscyadevrls")
    public fun learningRateScheduler(`value`: LearningRateScheduler) {
        val toBeMapped = Either.ofRight<String, LearningRateScheduler>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.learningRateScheduler = mapped
    }

    /**
     * @param value Name of the model to use for training.
     * For more information on the available models please visit the official documentation:
     * https://docs.microsoft.com/en-us/azure/machine-learning/how-to-auto-train-image-models.
     */
    @JvmName("ypbkujckykwabcjc")
    public suspend fun modelName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.modelName = mapped
    }

    /**
     * @param value Value of momentum when optimizer is 'sgd'. Must be a float in the range [0, 1].
     */
    @JvmName("losfidmklsolkbnx")
    public suspend fun momentum(`value`: Double?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.momentum = mapped
    }

    /**
     * @param value Enable nesterov when optimizer is 'sgd'.
     */
    @JvmName("msodhlhglgsakvam")
    public suspend fun nesterov(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.nesterov = mapped
    }

    /**
     * @param value Number of training epochs. Must be a positive integer.
     */
    @JvmName("cemnblbojxkwsiud")
    public suspend fun numberOfEpochs(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.numberOfEpochs = mapped
    }

    /**
     * @param value Number of data loader workers. Must be a non-negative integer.
     */
    @JvmName("cvayfoeryjxlqlct")
    public suspend fun numberOfWorkers(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.numberOfWorkers = mapped
    }

    /**
     * @param value Type of optimizer.
     */
    @JvmName("bpgejwforsvowooj")
    public suspend fun optimizer(`value`: Either<String, StochasticOptimizer>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.optimizer = mapped
    }

    /**
     * @param value Type of optimizer.
     */
    @JvmName("urjrposwlscsdwub")
    public fun optimizer(`value`: String) {
        val toBeMapped = Either.ofLeft<String, StochasticOptimizer>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.optimizer = mapped
    }

    /**
     * @param value Type of optimizer.
     */
    @JvmName("gxeexwsfdxkkhcaj")
    public fun optimizer(`value`: StochasticOptimizer) {
        val toBeMapped = Either.ofRight<String, StochasticOptimizer>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.optimizer = mapped
    }

    /**
     * @param value Random seed to be used when using deterministic training.
     */
    @JvmName("vpdhmcwcykrevkow")
    public suspend fun randomSeed(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.randomSeed = mapped
    }

    /**
     * @param value Value of gamma when learning rate scheduler is 'step'. Must be a float in the range [0, 1].
     */
    @JvmName("nvqgihofpcqssesv")
    public suspend fun stepLRGamma(`value`: Double?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.stepLRGamma = mapped
    }

    /**
     * @param value Value of step size when learning rate scheduler is 'step'. Must be a positive integer.
     */
    @JvmName("eqcjikmmwywknhhx")
    public suspend fun stepLRStepSize(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.stepLRStepSize = mapped
    }

    /**
     * @param value Training batch size. Must be a positive integer.
     */
    @JvmName("vtiiwncletaroogt")
    public suspend fun trainingBatchSize(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.trainingBatchSize = mapped
    }

    /**
     * @param value Image crop size that is input to the neural network for the training dataset. Must be a positive integer.
     */
    @JvmName("wvehiuriemdfutjs")
    public suspend fun trainingCropSize(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.trainingCropSize = mapped
    }

    /**
     * @param value Validation batch size. Must be a positive integer.
     */
    @JvmName("krqcwkgcfeekoauq")
    public suspend fun validationBatchSize(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.validationBatchSize = mapped
    }

    /**
     * @param value Image crop size that is input to the neural network for the validation dataset. Must be a positive integer.
     */
    @JvmName("pfirltghjnqfmofu")
    public suspend fun validationCropSize(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.validationCropSize = mapped
    }

    /**
     * @param value Image size to which to resize before cropping for validation dataset. Must be a positive integer.
     */
    @JvmName("dwyhfuycwduvkqsd")
    public suspend fun validationResizeSize(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.validationResizeSize = mapped
    }

    /**
     * @param value Value of cosine cycle when learning rate scheduler is 'warmup_cosine'. Must be a float in the range [0, 1].
     */
    @JvmName("hqvoqfvxsqwumljt")
    public suspend fun warmupCosineLRCycles(`value`: Double?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.warmupCosineLRCycles = mapped
    }

    /**
     * @param value Value of warmup epochs when learning rate scheduler is 'warmup_cosine'. Must be a positive integer.
     */
    @JvmName("ralmrtaenxixgkeq")
    public suspend fun warmupCosineLRWarmupEpochs(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.warmupCosineLRWarmupEpochs = mapped
    }

    /**
     * @param value Value of weight decay when optimizer is 'sgd', 'adam', or 'adamw'. Must be a float in the range[0, 1].
     */
    @JvmName("kqmxrpjqcvfsyiub")
    public suspend fun weightDecay(`value`: Double?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.weightDecay = mapped
    }

    /**
     * @param value Weighted loss. The accepted values are 0 for no weighted loss.
     * 1 for weighted loss with sqrt.(class_weights). 2 for weighted loss with class_weights. Must be 0 or 1 or 2.
     */
    @JvmName("aftsfmokoskyuyev")
    public suspend fun weightedLoss(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.weightedLoss = mapped
    }

    internal fun build(): ImageModelSettingsClassificationArgs = ImageModelSettingsClassificationArgs(
        advancedSettings = advancedSettings,
        amsGradient = amsGradient,
        augmentations = augmentations,
        beta1 = beta1,
        beta2 = beta2,
        checkpointFrequency = checkpointFrequency,
        checkpointModel = checkpointModel,
        checkpointRunId = checkpointRunId,
        distributed = distributed,
        earlyStopping = earlyStopping,
        earlyStoppingDelay = earlyStoppingDelay,
        earlyStoppingPatience = earlyStoppingPatience,
        enableOnnxNormalization = enableOnnxNormalization,
        evaluationFrequency = evaluationFrequency,
        gradientAccumulationStep = gradientAccumulationStep,
        layersToFreeze = layersToFreeze,
        learningRate = learningRate,
        learningRateScheduler = learningRateScheduler,
        modelName = modelName,
        momentum = momentum,
        nesterov = nesterov,
        numberOfEpochs = numberOfEpochs,
        numberOfWorkers = numberOfWorkers,
        optimizer = optimizer,
        randomSeed = randomSeed,
        stepLRGamma = stepLRGamma,
        stepLRStepSize = stepLRStepSize,
        trainingBatchSize = trainingBatchSize,
        trainingCropSize = trainingCropSize,
        validationBatchSize = validationBatchSize,
        validationCropSize = validationCropSize,
        validationResizeSize = validationResizeSize,
        warmupCosineLRCycles = warmupCosineLRCycles,
        warmupCosineLRWarmupEpochs = warmupCosineLRWarmupEpochs,
        weightDecay = weightDecay,
        weightedLoss = weightedLoss,
    )
}
