@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.machinelearningservices.kotlin.inputs

import com.pulumi.azurenative.machinelearningservices.inputs.InstanceTypeSchemaResourcesArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Resource requests/limits for this instance type
 * @property limits Resource limits for this instance type
 * @property requests Resource requests for this instance type
 */
public data class InstanceTypeSchemaResourcesArgs(
    public val limits: Output<Map<String, String>>? = null,
    public val requests: Output<Map<String, String>>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.machinelearningservices.inputs.InstanceTypeSchemaResourcesArgs> {
    override fun toJava():
        com.pulumi.azurenative.machinelearningservices.inputs.InstanceTypeSchemaResourcesArgs =
        com.pulumi.azurenative.machinelearningservices.inputs.InstanceTypeSchemaResourcesArgs.builder()
            .limits(limits?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .requests(
                requests?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [InstanceTypeSchemaResourcesArgs].
 */
@PulumiTagMarker
public class InstanceTypeSchemaResourcesArgsBuilder internal constructor() {
    private var limits: Output<Map<String, String>>? = null

    private var requests: Output<Map<String, String>>? = null

    /**
     * @param value Resource limits for this instance type
     */
    @JvmName("wojrgvsyqyekjyqs")
    public suspend fun limits(`value`: Output<Map<String, String>>) {
        this.limits = value
    }

    /**
     * @param value Resource requests for this instance type
     */
    @JvmName("gcpxjilghnyrkrqp")
    public suspend fun requests(`value`: Output<Map<String, String>>) {
        this.requests = value
    }

    /**
     * @param value Resource limits for this instance type
     */
    @JvmName("wetketpeemcaorsv")
    public suspend fun limits(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.limits = mapped
    }

    /**
     * @param values Resource limits for this instance type
     */
    @JvmName("khmkiirrrlncxbuv")
    public fun limits(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.limits = mapped
    }

    /**
     * @param value Resource requests for this instance type
     */
    @JvmName("wiroxunllkflhgcr")
    public suspend fun requests(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.requests = mapped
    }

    /**
     * @param values Resource requests for this instance type
     */
    @JvmName("rembsoowohnngfht")
    public fun requests(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.requests = mapped
    }

    internal fun build(): InstanceTypeSchemaResourcesArgs = InstanceTypeSchemaResourcesArgs(
        limits = limits,
        requests = requests,
    )
}
