@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.machinelearningservices.kotlin.inputs

import com.pulumi.azurenative.machinelearningservices.inputs.JobScheduleActionArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Any
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property actionType
 * Expected value is 'CreateJob'.
 * @property jobBaseProperties [Required] Defines Schedule action definition details.
 */
public data class JobScheduleActionArgs(
    public val actionType: Output<String>,
    public val jobBaseProperties: Output<Any>,
) : ConvertibleToJava<com.pulumi.azurenative.machinelearningservices.inputs.JobScheduleActionArgs> {
    override fun toJava(): com.pulumi.azurenative.machinelearningservices.inputs.JobScheduleActionArgs =
        com.pulumi.azurenative.machinelearningservices.inputs.JobScheduleActionArgs.builder()
            .actionType(actionType.applyValue({ args0 -> args0 }))
            .jobBaseProperties(jobBaseProperties.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [JobScheduleActionArgs].
 */
@PulumiTagMarker
public class JobScheduleActionArgsBuilder internal constructor() {
    private var actionType: Output<String>? = null

    private var jobBaseProperties: Output<Any>? = null

    /**
     * @param value
     * Expected value is 'CreateJob'.
     */
    @JvmName("jjxokvvnyrlxhuqv")
    public suspend fun actionType(`value`: Output<String>) {
        this.actionType = value
    }

    /**
     * @param value [Required] Defines Schedule action definition details.
     */
    @JvmName("nawlkkyjcehixcii")
    public suspend fun jobBaseProperties(`value`: Output<Any>) {
        this.jobBaseProperties = value
    }

    /**
     * @param value
     * Expected value is 'CreateJob'.
     */
    @JvmName("fasgbpaknqkuosuk")
    public suspend fun actionType(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.actionType = mapped
    }

    /**
     * @param value [Required] Defines Schedule action definition details.
     */
    @JvmName("dauscywiyondelsb")
    public suspend fun jobBaseProperties(`value`: Any) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.jobBaseProperties = mapped
    }

    internal fun build(): JobScheduleActionArgs = JobScheduleActionArgs(
        actionType = actionType ?: throw PulumiNullFieldException("actionType"),
        jobBaseProperties = jobBaseProperties ?: throw PulumiNullFieldException("jobBaseProperties"),
    )
}
