@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.machinelearningservices.kotlin.inputs

import com.pulumi.azurenative.machinelearningservices.inputs.LabelingJobInstructionsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Instructions for labeling job
 * @property uri The link to a page with detailed labeling instructions for labelers.
 */
public data class LabelingJobInstructionsArgs(
    public val uri: Output<String>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.machinelearningservices.inputs.LabelingJobInstructionsArgs> {
    override fun toJava():
        com.pulumi.azurenative.machinelearningservices.inputs.LabelingJobInstructionsArgs =
        com.pulumi.azurenative.machinelearningservices.inputs.LabelingJobInstructionsArgs.builder()
            .uri(uri?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [LabelingJobInstructionsArgs].
 */
@PulumiTagMarker
public class LabelingJobInstructionsArgsBuilder internal constructor() {
    private var uri: Output<String>? = null

    /**
     * @param value The link to a page with detailed labeling instructions for labelers.
     */
    @JvmName("qbohkeqtdfbplhoo")
    public suspend fun uri(`value`: Output<String>) {
        this.uri = value
    }

    /**
     * @param value The link to a page with detailed labeling instructions for labelers.
     */
    @JvmName("aajcxplkokkvkymw")
    public suspend fun uri(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.uri = mapped
    }

    internal fun build(): LabelingJobInstructionsArgs = LabelingJobInstructionsArgs(
        uri = uri,
    )
}
