@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.machinelearningservices.kotlin.inputs

import com.pulumi.azurenative.machinelearningservices.inputs.MLAssistConfigurationEnabledArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Labeling MLAssist configuration definition when MLAssist is enabled
 * @property inferencingComputeBinding [Required] AML compute binding used in inferencing.
 * @property mlAssist
 * Expected value is 'Enabled'.
 * @property trainingComputeBinding [Required] AML compute binding used in training.
 */
public data class MLAssistConfigurationEnabledArgs(
    public val inferencingComputeBinding: Output<String>,
    public val mlAssist: Output<String>,
    public val trainingComputeBinding: Output<String>,
) :
    ConvertibleToJava<com.pulumi.azurenative.machinelearningservices.inputs.MLAssistConfigurationEnabledArgs> {
    override fun toJava():
        com.pulumi.azurenative.machinelearningservices.inputs.MLAssistConfigurationEnabledArgs =
        com.pulumi.azurenative.machinelearningservices.inputs.MLAssistConfigurationEnabledArgs.builder()
            .inferencingComputeBinding(inferencingComputeBinding.applyValue({ args0 -> args0 }))
            .mlAssist(mlAssist.applyValue({ args0 -> args0 }))
            .trainingComputeBinding(trainingComputeBinding.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [MLAssistConfigurationEnabledArgs].
 */
@PulumiTagMarker
public class MLAssistConfigurationEnabledArgsBuilder internal constructor() {
    private var inferencingComputeBinding: Output<String>? = null

    private var mlAssist: Output<String>? = null

    private var trainingComputeBinding: Output<String>? = null

    /**
     * @param value [Required] AML compute binding used in inferencing.
     */
    @JvmName("wdkrfhplyromrouq")
    public suspend fun inferencingComputeBinding(`value`: Output<String>) {
        this.inferencingComputeBinding = value
    }

    /**
     * @param value
     * Expected value is 'Enabled'.
     */
    @JvmName("wqwggteqojpqpqsv")
    public suspend fun mlAssist(`value`: Output<String>) {
        this.mlAssist = value
    }

    /**
     * @param value [Required] AML compute binding used in training.
     */
    @JvmName("raguddhffhcaebxd")
    public suspend fun trainingComputeBinding(`value`: Output<String>) {
        this.trainingComputeBinding = value
    }

    /**
     * @param value [Required] AML compute binding used in inferencing.
     */
    @JvmName("miqgbfjcvqrxbjxf")
    public suspend fun inferencingComputeBinding(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.inferencingComputeBinding = mapped
    }

    /**
     * @param value
     * Expected value is 'Enabled'.
     */
    @JvmName("wqotngjkxdifjdye")
    public suspend fun mlAssist(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.mlAssist = mapped
    }

    /**
     * @param value [Required] AML compute binding used in training.
     */
    @JvmName("xljfdgarweoqqlww")
    public suspend fun trainingComputeBinding(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.trainingComputeBinding = mapped
    }

    internal fun build(): MLAssistConfigurationEnabledArgs = MLAssistConfigurationEnabledArgs(
        inferencingComputeBinding = inferencingComputeBinding ?: throw
            PulumiNullFieldException("inferencingComputeBinding"),
        mlAssist = mlAssist ?: throw PulumiNullFieldException("mlAssist"),
        trainingComputeBinding = trainingComputeBinding ?: throw
            PulumiNullFieldException("trainingComputeBinding"),
    )
}
