@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.machinelearningservices.kotlin.inputs

import com.pulumi.azurenative.machinelearningservices.inputs.ManagedIdentityArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Managed identity configuration.
 * @property clientId Specifies a user-assigned identity by client ID. For system-assigned, do not set this field.
 * @property identityType Enum to determine identity framework.
 * Expected value is 'Managed'.
 * @property objectId Specifies a user-assigned identity by object ID. For system-assigned, do not set this field.
 * @property resourceId Specifies a user-assigned identity by ARM resource ID. For system-assigned, do not set this field.
 */
public data class ManagedIdentityArgs(
    public val clientId: Output<String>? = null,
    public val identityType: Output<String>,
    public val objectId: Output<String>? = null,
    public val resourceId: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.machinelearningservices.inputs.ManagedIdentityArgs> {
    override fun toJava(): com.pulumi.azurenative.machinelearningservices.inputs.ManagedIdentityArgs =
        com.pulumi.azurenative.machinelearningservices.inputs.ManagedIdentityArgs.builder()
            .clientId(clientId?.applyValue({ args0 -> args0 }))
            .identityType(identityType.applyValue({ args0 -> args0 }))
            .objectId(objectId?.applyValue({ args0 -> args0 }))
            .resourceId(resourceId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ManagedIdentityArgs].
 */
@PulumiTagMarker
public class ManagedIdentityArgsBuilder internal constructor() {
    private var clientId: Output<String>? = null

    private var identityType: Output<String>? = null

    private var objectId: Output<String>? = null

    private var resourceId: Output<String>? = null

    /**
     * @param value Specifies a user-assigned identity by client ID. For system-assigned, do not set this field.
     */
    @JvmName("cwewrpinsrlumdbh")
    public suspend fun clientId(`value`: Output<String>) {
        this.clientId = value
    }

    /**
     * @param value Enum to determine identity framework.
     * Expected value is 'Managed'.
     */
    @JvmName("tyhyrkqokxxguref")
    public suspend fun identityType(`value`: Output<String>) {
        this.identityType = value
    }

    /**
     * @param value Specifies a user-assigned identity by object ID. For system-assigned, do not set this field.
     */
    @JvmName("ysrkfhfmtnoocexo")
    public suspend fun objectId(`value`: Output<String>) {
        this.objectId = value
    }

    /**
     * @param value Specifies a user-assigned identity by ARM resource ID. For system-assigned, do not set this field.
     */
    @JvmName("ivydcseismwmjyfx")
    public suspend fun resourceId(`value`: Output<String>) {
        this.resourceId = value
    }

    /**
     * @param value Specifies a user-assigned identity by client ID. For system-assigned, do not set this field.
     */
    @JvmName("cvmurgwtnbwnfbar")
    public suspend fun clientId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.clientId = mapped
    }

    /**
     * @param value Enum to determine identity framework.
     * Expected value is 'Managed'.
     */
    @JvmName("vafqohgxfdwvdirl")
    public suspend fun identityType(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.identityType = mapped
    }

    /**
     * @param value Specifies a user-assigned identity by object ID. For system-assigned, do not set this field.
     */
    @JvmName("lyyrgunruxrahnrs")
    public suspend fun objectId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.objectId = mapped
    }

    /**
     * @param value Specifies a user-assigned identity by ARM resource ID. For system-assigned, do not set this field.
     */
    @JvmName("fuvkprxwuyqukkma")
    public suspend fun resourceId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceId = mapped
    }

    internal fun build(): ManagedIdentityArgs = ManagedIdentityArgs(
        clientId = clientId,
        identityType = identityType ?: throw PulumiNullFieldException("identityType"),
        objectId = objectId,
        resourceId = resourceId,
    )
}
