@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.machinelearningservices.kotlin.inputs

import com.pulumi.azurenative.machinelearningservices.inputs.ManagedIdentityAuthTypeWorkspaceConnectionPropertiesArgs.builder
import com.pulumi.azurenative.machinelearningservices.kotlin.enums.ConnectionCategory
import com.pulumi.azurenative.machinelearningservices.kotlin.enums.ValueFormat
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property authType Authentication type of the connection target
 * Expected value is 'ManagedIdentity'.
 * @property category Category of the connection
 * @property credentials
 * @property target
 * @property value Value details of the workspace connection.
 * @property valueFormat format for the workspace connection value
 */
public data class ManagedIdentityAuthTypeWorkspaceConnectionPropertiesArgs(
    public val authType: Output<String>,
    public val category: Output<Either<String, ConnectionCategory>>? = null,
    public val credentials: Output<WorkspaceConnectionManagedIdentityArgs>? = null,
    public val target: Output<String>? = null,
    public val `value`: Output<String>? = null,
    public val valueFormat: Output<Either<String, ValueFormat>>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.machinelearningservices.inputs.ManagedIdentityAuthTypeWorkspaceConnectionPropertiesArgs> {
    override fun toJava():
        com.pulumi.azurenative.machinelearningservices.inputs.ManagedIdentityAuthTypeWorkspaceConnectionPropertiesArgs =
        com.pulumi.azurenative.machinelearningservices.inputs.ManagedIdentityAuthTypeWorkspaceConnectionPropertiesArgs.builder()
            .authType(authType.applyValue({ args0 -> args0 }))
            .category(
                category?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .credentials(credentials?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .target(target?.applyValue({ args0 -> args0 }))
            .`value`(`value`?.applyValue({ args0 -> args0 }))
            .valueFormat(
                valueFormat?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            ).build()
}

/**
 * Builder for [ManagedIdentityAuthTypeWorkspaceConnectionPropertiesArgs].
 */
@PulumiTagMarker
public class ManagedIdentityAuthTypeWorkspaceConnectionPropertiesArgsBuilder internal constructor() {
    private var authType: Output<String>? = null

    private var category: Output<Either<String, ConnectionCategory>>? = null

    private var credentials: Output<WorkspaceConnectionManagedIdentityArgs>? = null

    private var target: Output<String>? = null

    private var `value`: Output<String>? = null

    private var valueFormat: Output<Either<String, ValueFormat>>? = null

    /**
     * @param value Authentication type of the connection target
     * Expected value is 'ManagedIdentity'.
     */
    @JvmName("vjhlqjmkapukaanb")
    public suspend fun authType(`value`: Output<String>) {
        this.authType = value
    }

    /**
     * @param value Category of the connection
     */
    @JvmName("oybplarijfglxjma")
    public suspend fun category(`value`: Output<Either<String, ConnectionCategory>>) {
        this.category = value
    }

    /**
     * @param value
     */
    @JvmName("ysdseqclcgwhelbu")
    public suspend fun credentials(`value`: Output<WorkspaceConnectionManagedIdentityArgs>) {
        this.credentials = value
    }

    /**
     * @param value
     */
    @JvmName("keelxfjxjxifxrws")
    public suspend fun target(`value`: Output<String>) {
        this.target = value
    }

    /**
     * @param value Value details of the workspace connection.
     */
    @JvmName("vwjpppnhruyoyolx")
    public suspend fun `value`(`value`: Output<String>) {
        this.`value` = value
    }

    /**
     * @param value format for the workspace connection value
     */
    @JvmName("rujrvymumqxsqebj")
    public suspend fun valueFormat(`value`: Output<Either<String, ValueFormat>>) {
        this.valueFormat = value
    }

    /**
     * @param value Authentication type of the connection target
     * Expected value is 'ManagedIdentity'.
     */
    @JvmName("fpgqyqfybbgoaulm")
    public suspend fun authType(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.authType = mapped
    }

    /**
     * @param value Category of the connection
     */
    @JvmName("sqtcgwabprqdposf")
    public suspend fun category(`value`: Either<String, ConnectionCategory>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.category = mapped
    }

    /**
     * @param value Category of the connection
     */
    @JvmName("jtsulciyqmhxihdn")
    public fun category(`value`: String) {
        val toBeMapped = Either.ofLeft<String, ConnectionCategory>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.category = mapped
    }

    /**
     * @param value Category of the connection
     */
    @JvmName("myrhxdsaqdilxghi")
    public fun category(`value`: ConnectionCategory) {
        val toBeMapped = Either.ofRight<String, ConnectionCategory>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.category = mapped
    }

    /**
     * @param value
     */
    @JvmName("biqegabcejewncsp")
    public suspend fun credentials(`value`: WorkspaceConnectionManagedIdentityArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.credentials = mapped
    }

    /**
     * @param argument
     */
    @JvmName("dbvrnisdgrebqqwr")
    public suspend
    fun credentials(argument: suspend WorkspaceConnectionManagedIdentityArgsBuilder.() -> Unit) {
        val toBeMapped = WorkspaceConnectionManagedIdentityArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.credentials = mapped
    }

    /**
     * @param value
     */
    @JvmName("dfvbvmbcgrdcpiwj")
    public suspend fun target(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.target = mapped
    }

    /**
     * @param value Value details of the workspace connection.
     */
    @JvmName("tndepvbayyaiwfon")
    public suspend fun `value`(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.`value` = mapped
    }

    /**
     * @param value format for the workspace connection value
     */
    @JvmName("bvgqbmrtrkbsbxsl")
    public suspend fun valueFormat(`value`: Either<String, ValueFormat>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.valueFormat = mapped
    }

    /**
     * @param value format for the workspace connection value
     */
    @JvmName("itkcowhqxycdgwct")
    public fun valueFormat(`value`: String) {
        val toBeMapped = Either.ofLeft<String, ValueFormat>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.valueFormat = mapped
    }

    /**
     * @param value format for the workspace connection value
     */
    @JvmName("ylktmlmadodqjxus")
    public fun valueFormat(`value`: ValueFormat) {
        val toBeMapped = Either.ofRight<String, ValueFormat>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.valueFormat = mapped
    }

    internal fun build(): ManagedIdentityAuthTypeWorkspaceConnectionPropertiesArgs =
        ManagedIdentityAuthTypeWorkspaceConnectionPropertiesArgs(
            authType = authType ?: throw PulumiNullFieldException("authType"),
            category = category,
            credentials = credentials,
            target = target,
            `value` = `value`,
            valueFormat = valueFormat,
        )
}
