@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.machinelearningservices.kotlin.inputs

import com.pulumi.azurenative.machinelearningservices.inputs.MedianStoppingPolicyArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Defines an early termination policy based on running averages of the primary metric of all runs
 * @property delayEvaluation Number of intervals by which to delay the first evaluation.
 * @property evaluationInterval Interval (number of runs) between policy evaluations.
 * @property policyType
 * Expected value is 'MedianStopping'.
 */
public data class MedianStoppingPolicyArgs(
    public val delayEvaluation: Output<Int>? = null,
    public val evaluationInterval: Output<Int>? = null,
    public val policyType: Output<String>,
) :
    ConvertibleToJava<com.pulumi.azurenative.machinelearningservices.inputs.MedianStoppingPolicyArgs> {
    override fun toJava():
        com.pulumi.azurenative.machinelearningservices.inputs.MedianStoppingPolicyArgs =
        com.pulumi.azurenative.machinelearningservices.inputs.MedianStoppingPolicyArgs.builder()
            .delayEvaluation(delayEvaluation?.applyValue({ args0 -> args0 }))
            .evaluationInterval(evaluationInterval?.applyValue({ args0 -> args0 }))
            .policyType(policyType.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [MedianStoppingPolicyArgs].
 */
@PulumiTagMarker
public class MedianStoppingPolicyArgsBuilder internal constructor() {
    private var delayEvaluation: Output<Int>? = null

    private var evaluationInterval: Output<Int>? = null

    private var policyType: Output<String>? = null

    /**
     * @param value Number of intervals by which to delay the first evaluation.
     */
    @JvmName("gxeexowtgphcnark")
    public suspend fun delayEvaluation(`value`: Output<Int>) {
        this.delayEvaluation = value
    }

    /**
     * @param value Interval (number of runs) between policy evaluations.
     */
    @JvmName("oomajxiaiotqkyyp")
    public suspend fun evaluationInterval(`value`: Output<Int>) {
        this.evaluationInterval = value
    }

    /**
     * @param value
     * Expected value is 'MedianStopping'.
     */
    @JvmName("cobehqudujsvnmxn")
    public suspend fun policyType(`value`: Output<String>) {
        this.policyType = value
    }

    /**
     * @param value Number of intervals by which to delay the first evaluation.
     */
    @JvmName("fkprjafhfyobpfic")
    public suspend fun delayEvaluation(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.delayEvaluation = mapped
    }

    /**
     * @param value Interval (number of runs) between policy evaluations.
     */
    @JvmName("qdcbxaltrwifwjbs")
    public suspend fun evaluationInterval(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.evaluationInterval = mapped
    }

    /**
     * @param value
     * Expected value is 'MedianStopping'.
     */
    @JvmName("vhaquecswurqrdma")
    public suspend fun policyType(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.policyType = mapped
    }

    internal fun build(): MedianStoppingPolicyArgs = MedianStoppingPolicyArgs(
        delayEvaluation = delayEvaluation,
        evaluationInterval = evaluationInterval,
        policyType = policyType ?: throw PulumiNullFieldException("policyType"),
    )
}
