@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.machinelearningservices.kotlin.inputs

import com.pulumi.azurenative.machinelearningservices.inputs.ModelVersionArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Model asset version details.
 * @property description The asset description text.
 * @property flavors Mapping of model flavors to their properties.
 * @property isAnonymous If the name version are system generated (anonymous registration).
 * @property isArchived Is the asset archived?
 * @property jobName Name of the training job which produced this model
 * @property modelType The storage format for this entity. Used for NCD.
 * @property modelUri The URI path to the model contents.
 * @property properties The asset property dictionary.
 * @property stage Stage in the model lifecycle assigned to this model
 * @property tags Tag dictionary. Tags can be added, removed, and updated.
 */
public data class ModelVersionArgs(
    public val description: Output<String>? = null,
    public val flavors: Output<Map<String, FlavorDataArgs>>? = null,
    public val isAnonymous: Output<Boolean>? = null,
    public val isArchived: Output<Boolean>? = null,
    public val jobName: Output<String>? = null,
    public val modelType: Output<String>? = null,
    public val modelUri: Output<String>? = null,
    public val properties: Output<Map<String, String>>? = null,
    public val stage: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.machinelearningservices.inputs.ModelVersionArgs> {
    override fun toJava(): com.pulumi.azurenative.machinelearningservices.inputs.ModelVersionArgs =
        com.pulumi.azurenative.machinelearningservices.inputs.ModelVersionArgs.builder()
            .description(description?.applyValue({ args0 -> args0 }))
            .flavors(
                flavors?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(
                            args0.value.let({ args0 ->
                                args0.toJava()
                            }),
                        )
                    }).toMap()
                }),
            )
            .isAnonymous(isAnonymous?.applyValue({ args0 -> args0 }))
            .isArchived(isArchived?.applyValue({ args0 -> args0 }))
            .jobName(jobName?.applyValue({ args0 -> args0 }))
            .modelType(modelType?.applyValue({ args0 -> args0 }))
            .modelUri(modelUri?.applyValue({ args0 -> args0 }))
            .properties(
                properties?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            )
            .stage(stage?.applyValue({ args0 -> args0 }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [ModelVersionArgs].
 */
@PulumiTagMarker
public class ModelVersionArgsBuilder internal constructor() {
    private var description: Output<String>? = null

    private var flavors: Output<Map<String, FlavorDataArgs>>? = null

    private var isAnonymous: Output<Boolean>? = null

    private var isArchived: Output<Boolean>? = null

    private var jobName: Output<String>? = null

    private var modelType: Output<String>? = null

    private var modelUri: Output<String>? = null

    private var properties: Output<Map<String, String>>? = null

    private var stage: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value The asset description text.
     */
    @JvmName("kythsuwoyjkaeqnu")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value Mapping of model flavors to their properties.
     */
    @JvmName("wuiydreobbuhkbah")
    public suspend fun flavors(`value`: Output<Map<String, FlavorDataArgs>>) {
        this.flavors = value
    }

    /**
     * @param value If the name version are system generated (anonymous registration).
     */
    @JvmName("nwxfflwuvmniihke")
    public suspend fun isAnonymous(`value`: Output<Boolean>) {
        this.isAnonymous = value
    }

    /**
     * @param value Is the asset archived?
     */
    @JvmName("ryhqbcyiggkxgjkh")
    public suspend fun isArchived(`value`: Output<Boolean>) {
        this.isArchived = value
    }

    /**
     * @param value Name of the training job which produced this model
     */
    @JvmName("hkrbnimqevospbxr")
    public suspend fun jobName(`value`: Output<String>) {
        this.jobName = value
    }

    /**
     * @param value The storage format for this entity. Used for NCD.
     */
    @JvmName("hhtggdycssjusjvq")
    public suspend fun modelType(`value`: Output<String>) {
        this.modelType = value
    }

    /**
     * @param value The URI path to the model contents.
     */
    @JvmName("npkhhmlopbsxhwea")
    public suspend fun modelUri(`value`: Output<String>) {
        this.modelUri = value
    }

    /**
     * @param value The asset property dictionary.
     */
    @JvmName("wpibpjfrgwmaorbf")
    public suspend fun properties(`value`: Output<Map<String, String>>) {
        this.properties = value
    }

    /**
     * @param value Stage in the model lifecycle assigned to this model
     */
    @JvmName("mrdfgqmjxgxjcujl")
    public suspend fun stage(`value`: Output<String>) {
        this.stage = value
    }

    /**
     * @param value Tag dictionary. Tags can be added, removed, and updated.
     */
    @JvmName("yfqtuyexlmntmohl")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The asset description text.
     */
    @JvmName("ljtxqinjqhseevam")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value Mapping of model flavors to their properties.
     */
    @JvmName("mxojanvyglnwlhfy")
    public suspend fun flavors(`value`: Map<String, FlavorDataArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.flavors = mapped
    }

    /**
     * @param argument Mapping of model flavors to their properties.
     */
    @JvmName("lycdaikqvjijccqm")
    public suspend fun flavors(
        vararg
        argument: Pair<String, suspend FlavorDataArgsBuilder.() -> Unit>,
    ) {
        val toBeMapped = argument.toList().map { (left, right) ->
            left to
                FlavorDataArgsBuilder().applySuspend { right() }.build()
        }.toMap()
        val mapped = of(toBeMapped)
        this.flavors = mapped
    }

    /**
     * @param values Mapping of model flavors to their properties.
     */
    @JvmName("rymwytceojaxugxe")
    public fun flavors(vararg values: Pair<String, FlavorDataArgs>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.flavors = mapped
    }

    /**
     * @param value If the name version are system generated (anonymous registration).
     */
    @JvmName("jrfyitaminwpbtva")
    public suspend fun isAnonymous(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.isAnonymous = mapped
    }

    /**
     * @param value Is the asset archived?
     */
    @JvmName("lbcpdifpidfijste")
    public suspend fun isArchived(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.isArchived = mapped
    }

    /**
     * @param value Name of the training job which produced this model
     */
    @JvmName("cfulhrtdhkkpjbxe")
    public suspend fun jobName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.jobName = mapped
    }

    /**
     * @param value The storage format for this entity. Used for NCD.
     */
    @JvmName("uqyyetwmdrsdvgpk")
    public suspend fun modelType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.modelType = mapped
    }

    /**
     * @param value The URI path to the model contents.
     */
    @JvmName("dniqcukjaunlvlet")
    public suspend fun modelUri(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.modelUri = mapped
    }

    /**
     * @param value The asset property dictionary.
     */
    @JvmName("selkljbiajxeukrm")
    public suspend fun properties(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.properties = mapped
    }

    /**
     * @param values The asset property dictionary.
     */
    @JvmName("gocepgixotpospem")
    public fun properties(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.properties = mapped
    }

    /**
     * @param value Stage in the model lifecycle assigned to this model
     */
    @JvmName("qiieknbrwxqkfdsa")
    public suspend fun stage(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.stage = mapped
    }

    /**
     * @param value Tag dictionary. Tags can be added, removed, and updated.
     */
    @JvmName("bpgpjdbkpwhaopgy")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Tag dictionary. Tags can be added, removed, and updated.
     */
    @JvmName("ldmuxiideaaaetii")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): ModelVersionArgs = ModelVersionArgs(
        description = description,
        flavors = flavors,
        isAnonymous = isAnonymous,
        isArchived = isArchived,
        jobName = jobName,
        modelType = modelType,
        modelUri = modelUri,
        properties = properties,
        stage = stage,
        tags = tags,
    )
}
