@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.machinelearningservices.kotlin.inputs

import com.pulumi.azurenative.machinelearningservices.inputs.RecurrenceScheduleArgs.builder
import com.pulumi.azurenative.machinelearningservices.kotlin.enums.WeekDay
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property hours [Required] List of hours for the schedule.
 * @property minutes [Required] List of minutes for the schedule.
 * @property monthDays List of month days for the schedule
 * @property weekDays List of days for the schedule.
 */
public data class RecurrenceScheduleArgs(
    public val hours: Output<List<Int>>,
    public val minutes: Output<List<Int>>,
    public val monthDays: Output<List<Int>>? = null,
    public val weekDays: Output<List<Either<String, WeekDay>>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.machinelearningservices.inputs.RecurrenceScheduleArgs> {
    override fun toJava():
        com.pulumi.azurenative.machinelearningservices.inputs.RecurrenceScheduleArgs =
        com.pulumi.azurenative.machinelearningservices.inputs.RecurrenceScheduleArgs.builder()
            .hours(hours.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .minutes(minutes.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .monthDays(monthDays?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .weekDays(
                weekDays?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.transform(
                            { args0 -> args0 },
                            { args0 -> args0.let({ args0 -> args0.toJava() }) },
                        )
                    })
                }),
            ).build()
}

/**
 * Builder for [RecurrenceScheduleArgs].
 */
@PulumiTagMarker
public class RecurrenceScheduleArgsBuilder internal constructor() {
    private var hours: Output<List<Int>>? = null

    private var minutes: Output<List<Int>>? = null

    private var monthDays: Output<List<Int>>? = null

    private var weekDays: Output<List<Either<String, WeekDay>>>? = null

    /**
     * @param value [Required] List of hours for the schedule.
     */
    @JvmName("wqejcluwvooxjohf")
    public suspend fun hours(`value`: Output<List<Int>>) {
        this.hours = value
    }

    @JvmName("wiasmietsbmojmya")
    public suspend fun hours(vararg values: Output<Int>) {
        this.hours = Output.all(values.asList())
    }

    /**
     * @param values [Required] List of hours for the schedule.
     */
    @JvmName("oavhgvmrsulqcouu")
    public suspend fun hours(values: List<Output<Int>>) {
        this.hours = Output.all(values)
    }

    /**
     * @param value [Required] List of minutes for the schedule.
     */
    @JvmName("tfowbbprjheyhwlo")
    public suspend fun minutes(`value`: Output<List<Int>>) {
        this.minutes = value
    }

    @JvmName("rxrlpyhqpuidibdu")
    public suspend fun minutes(vararg values: Output<Int>) {
        this.minutes = Output.all(values.asList())
    }

    /**
     * @param values [Required] List of minutes for the schedule.
     */
    @JvmName("cickhngvswahddkk")
    public suspend fun minutes(values: List<Output<Int>>) {
        this.minutes = Output.all(values)
    }

    /**
     * @param value List of month days for the schedule
     */
    @JvmName("dhqndhduwhuubqny")
    public suspend fun monthDays(`value`: Output<List<Int>>) {
        this.monthDays = value
    }

    @JvmName("lghfcvupjacirddi")
    public suspend fun monthDays(vararg values: Output<Int>) {
        this.monthDays = Output.all(values.asList())
    }

    /**
     * @param values List of month days for the schedule
     */
    @JvmName("tdxctypxuguvfxkn")
    public suspend fun monthDays(values: List<Output<Int>>) {
        this.monthDays = Output.all(values)
    }

    /**
     * @param value List of days for the schedule.
     */
    @JvmName("ulsmnsfhirxssyei")
    public suspend fun weekDays(`value`: Output<List<Either<String, WeekDay>>>) {
        this.weekDays = value
    }

    @JvmName("gfwmyyedwuaxlytd")
    public suspend fun weekDays(vararg values: Output<Either<String, WeekDay>>) {
        this.weekDays = Output.all(values.asList())
    }

    /**
     * @param values List of days for the schedule.
     */
    @JvmName("agrusfdlsttkquri")
    public suspend fun weekDays(values: List<Output<Either<String, WeekDay>>>) {
        this.weekDays = Output.all(values)
    }

    /**
     * @param value [Required] List of hours for the schedule.
     */
    @JvmName("cycarwjjubboviih")
    public suspend fun hours(`value`: List<Int>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.hours = mapped
    }

    /**
     * @param values [Required] List of hours for the schedule.
     */
    @JvmName("grbuikomcaywruuq")
    public suspend fun hours(vararg values: Int) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.hours = mapped
    }

    /**
     * @param value [Required] List of minutes for the schedule.
     */
    @JvmName("ljdgbgfeenssmwag")
    public suspend fun minutes(`value`: List<Int>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.minutes = mapped
    }

    /**
     * @param values [Required] List of minutes for the schedule.
     */
    @JvmName("bfjmpjrqxxarctdq")
    public suspend fun minutes(vararg values: Int) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.minutes = mapped
    }

    /**
     * @param value List of month days for the schedule
     */
    @JvmName("pllgglihrphycxdc")
    public suspend fun monthDays(`value`: List<Int>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.monthDays = mapped
    }

    /**
     * @param values List of month days for the schedule
     */
    @JvmName("uglyykfauneckmrn")
    public suspend fun monthDays(vararg values: Int) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.monthDays = mapped
    }

    /**
     * @param value List of days for the schedule.
     */
    @JvmName("qxnshdsbecfubqxf")
    public suspend fun weekDays(`value`: List<Either<String, WeekDay>>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.weekDays = mapped
    }

    /**
     * @param values List of days for the schedule.
     */
    @JvmName("txqagslipuugyrfy")
    public suspend fun weekDays(vararg values: Either<String, WeekDay>) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.weekDays = mapped
    }

    internal fun build(): RecurrenceScheduleArgs = RecurrenceScheduleArgs(
        hours = hours ?: throw PulumiNullFieldException("hours"),
        minutes = minutes ?: throw PulumiNullFieldException("minutes"),
        monthDays = monthDays,
        weekDays = weekDays,
    )
}
