@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.machinelearningservices.kotlin.inputs

import com.pulumi.azurenative.machinelearningservices.inputs.RegressionTrainingSettingsArgs.builder
import com.pulumi.azurenative.machinelearningservices.kotlin.enums.RegressionModels
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Regression Training related configuration.
 * @property allowedTrainingAlgorithms Allowed models for regression task.
 * @property blockedTrainingAlgorithms Blocked models for regression task.
 * @property enableDnnTraining Enable recommendation of DNN models.
 * @property enableModelExplainability Flag to turn on explainability on best model.
 * @property enableOnnxCompatibleModels Flag for enabling onnx compatible models.
 * @property enableStackEnsemble Enable stack ensemble run.
 * @property enableVoteEnsemble Enable voting ensemble run.
 * @property ensembleModelDownloadTimeout During VotingEnsemble and StackEnsemble model generation, multiple fitted models from the previous child runs are downloaded.
 * Configure this parameter with a higher value than 300 secs, if more time is needed.
 * @property stackEnsembleSettings Stack ensemble settings for stack ensemble run.
 */
public data class RegressionTrainingSettingsArgs(
    public val allowedTrainingAlgorithms: Output<List<Either<String, RegressionModels>>>? = null,
    public val blockedTrainingAlgorithms: Output<List<Either<String, RegressionModels>>>? = null,
    public val enableDnnTraining: Output<Boolean>? = null,
    public val enableModelExplainability: Output<Boolean>? = null,
    public val enableOnnxCompatibleModels: Output<Boolean>? = null,
    public val enableStackEnsemble: Output<Boolean>? = null,
    public val enableVoteEnsemble: Output<Boolean>? = null,
    public val ensembleModelDownloadTimeout: Output<String>? = null,
    public val stackEnsembleSettings: Output<StackEnsembleSettingsArgs>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.machinelearningservices.inputs.RegressionTrainingSettingsArgs> {
    override fun toJava():
        com.pulumi.azurenative.machinelearningservices.inputs.RegressionTrainingSettingsArgs =
        com.pulumi.azurenative.machinelearningservices.inputs.RegressionTrainingSettingsArgs.builder()
            .allowedTrainingAlgorithms(
                allowedTrainingAlgorithms?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.transform({ args0 -> args0 }, { args0 -> args0.let({ args0 -> args0.toJava() }) })
                    })
                }),
            )
            .blockedTrainingAlgorithms(
                blockedTrainingAlgorithms?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.transform({ args0 -> args0 }, { args0 -> args0.let({ args0 -> args0.toJava() }) })
                    })
                }),
            )
            .enableDnnTraining(enableDnnTraining?.applyValue({ args0 -> args0 }))
            .enableModelExplainability(enableModelExplainability?.applyValue({ args0 -> args0 }))
            .enableOnnxCompatibleModels(enableOnnxCompatibleModels?.applyValue({ args0 -> args0 }))
            .enableStackEnsemble(enableStackEnsemble?.applyValue({ args0 -> args0 }))
            .enableVoteEnsemble(enableVoteEnsemble?.applyValue({ args0 -> args0 }))
            .ensembleModelDownloadTimeout(ensembleModelDownloadTimeout?.applyValue({ args0 -> args0 }))
            .stackEnsembleSettings(
                stackEnsembleSettings?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            ).build()
}

/**
 * Builder for [RegressionTrainingSettingsArgs].
 */
@PulumiTagMarker
public class RegressionTrainingSettingsArgsBuilder internal constructor() {
    private var allowedTrainingAlgorithms: Output<List<Either<String, RegressionModels>>>? = null

    private var blockedTrainingAlgorithms: Output<List<Either<String, RegressionModels>>>? = null

    private var enableDnnTraining: Output<Boolean>? = null

    private var enableModelExplainability: Output<Boolean>? = null

    private var enableOnnxCompatibleModels: Output<Boolean>? = null

    private var enableStackEnsemble: Output<Boolean>? = null

    private var enableVoteEnsemble: Output<Boolean>? = null

    private var ensembleModelDownloadTimeout: Output<String>? = null

    private var stackEnsembleSettings: Output<StackEnsembleSettingsArgs>? = null

    /**
     * @param value Allowed models for regression task.
     */
    @JvmName("rcjlmdoppntltdnk")
    public suspend
    fun allowedTrainingAlgorithms(`value`: Output<List<Either<String, RegressionModels>>>) {
        this.allowedTrainingAlgorithms = value
    }

    @JvmName("puscdjnddeosbajg")
    public suspend fun allowedTrainingAlgorithms(
        vararg
        values: Output<Either<String, RegressionModels>>,
    ) {
        this.allowedTrainingAlgorithms = Output.all(values.asList())
    }

    /**
     * @param values Allowed models for regression task.
     */
    @JvmName("ngyesyagckbpcits")
    public suspend
    fun allowedTrainingAlgorithms(values: List<Output<Either<String, RegressionModels>>>) {
        this.allowedTrainingAlgorithms = Output.all(values)
    }

    /**
     * @param value Blocked models for regression task.
     */
    @JvmName("myepwgplcyyjgpgt")
    public suspend
    fun blockedTrainingAlgorithms(`value`: Output<List<Either<String, RegressionModels>>>) {
        this.blockedTrainingAlgorithms = value
    }

    @JvmName("ljtbqlnjocqxldci")
    public suspend fun blockedTrainingAlgorithms(
        vararg
        values: Output<Either<String, RegressionModels>>,
    ) {
        this.blockedTrainingAlgorithms = Output.all(values.asList())
    }

    /**
     * @param values Blocked models for regression task.
     */
    @JvmName("prcroisphuftmxaj")
    public suspend
    fun blockedTrainingAlgorithms(values: List<Output<Either<String, RegressionModels>>>) {
        this.blockedTrainingAlgorithms = Output.all(values)
    }

    /**
     * @param value Enable recommendation of DNN models.
     */
    @JvmName("afhhycapudndunwp")
    public suspend fun enableDnnTraining(`value`: Output<Boolean>) {
        this.enableDnnTraining = value
    }

    /**
     * @param value Flag to turn on explainability on best model.
     */
    @JvmName("rdstlxbnrasytrjs")
    public suspend fun enableModelExplainability(`value`: Output<Boolean>) {
        this.enableModelExplainability = value
    }

    /**
     * @param value Flag for enabling onnx compatible models.
     */
    @JvmName("axoppyuenoeegvyk")
    public suspend fun enableOnnxCompatibleModels(`value`: Output<Boolean>) {
        this.enableOnnxCompatibleModels = value
    }

    /**
     * @param value Enable stack ensemble run.
     */
    @JvmName("dlajirylvrqxatrl")
    public suspend fun enableStackEnsemble(`value`: Output<Boolean>) {
        this.enableStackEnsemble = value
    }

    /**
     * @param value Enable voting ensemble run.
     */
    @JvmName("brdyerbdkkngbdhw")
    public suspend fun enableVoteEnsemble(`value`: Output<Boolean>) {
        this.enableVoteEnsemble = value
    }

    /**
     * @param value During VotingEnsemble and StackEnsemble model generation, multiple fitted models from the previous child runs are downloaded.
     * Configure this parameter with a higher value than 300 secs, if more time is needed.
     */
    @JvmName("emuxfhrbxctkelbr")
    public suspend fun ensembleModelDownloadTimeout(`value`: Output<String>) {
        this.ensembleModelDownloadTimeout = value
    }

    /**
     * @param value Stack ensemble settings for stack ensemble run.
     */
    @JvmName("imydgdivpfyodjpv")
    public suspend fun stackEnsembleSettings(`value`: Output<StackEnsembleSettingsArgs>) {
        this.stackEnsembleSettings = value
    }

    /**
     * @param value Allowed models for regression task.
     */
    @JvmName("rbxympqgyactktfs")
    public suspend fun allowedTrainingAlgorithms(`value`: List<Either<String, RegressionModels>>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.allowedTrainingAlgorithms = mapped
    }

    /**
     * @param values Allowed models for regression task.
     */
    @JvmName("jmambphhyixvayyf")
    public suspend fun allowedTrainingAlgorithms(vararg values: Either<String, RegressionModels>) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.allowedTrainingAlgorithms = mapped
    }

    /**
     * @param value Blocked models for regression task.
     */
    @JvmName("pkpnuexvjmgacglg")
    public suspend fun blockedTrainingAlgorithms(`value`: List<Either<String, RegressionModels>>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.blockedTrainingAlgorithms = mapped
    }

    /**
     * @param values Blocked models for regression task.
     */
    @JvmName("eybophfnkbgtmpoc")
    public suspend fun blockedTrainingAlgorithms(vararg values: Either<String, RegressionModels>) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.blockedTrainingAlgorithms = mapped
    }

    /**
     * @param value Enable recommendation of DNN models.
     */
    @JvmName("dwpqfbcslgjqawbq")
    public suspend fun enableDnnTraining(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enableDnnTraining = mapped
    }

    /**
     * @param value Flag to turn on explainability on best model.
     */
    @JvmName("clqrphxxpgcknkak")
    public suspend fun enableModelExplainability(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enableModelExplainability = mapped
    }

    /**
     * @param value Flag for enabling onnx compatible models.
     */
    @JvmName("erbmohihdedrevxj")
    public suspend fun enableOnnxCompatibleModels(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enableOnnxCompatibleModels = mapped
    }

    /**
     * @param value Enable stack ensemble run.
     */
    @JvmName("hdswuemoirepmtjb")
    public suspend fun enableStackEnsemble(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enableStackEnsemble = mapped
    }

    /**
     * @param value Enable voting ensemble run.
     */
    @JvmName("wgcnrcdrjaxcoddj")
    public suspend fun enableVoteEnsemble(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enableVoteEnsemble = mapped
    }

    /**
     * @param value During VotingEnsemble and StackEnsemble model generation, multiple fitted models from the previous child runs are downloaded.
     * Configure this parameter with a higher value than 300 secs, if more time is needed.
     */
    @JvmName("pcngoxsyqqkexmjn")
    public suspend fun ensembleModelDownloadTimeout(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ensembleModelDownloadTimeout = mapped
    }

    /**
     * @param value Stack ensemble settings for stack ensemble run.
     */
    @JvmName("utucaduasufwsiuq")
    public suspend fun stackEnsembleSettings(`value`: StackEnsembleSettingsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.stackEnsembleSettings = mapped
    }

    /**
     * @param argument Stack ensemble settings for stack ensemble run.
     */
    @JvmName("cmrpxmifdxiqjbpe")
    public suspend
    fun stackEnsembleSettings(argument: suspend StackEnsembleSettingsArgsBuilder.() -> Unit) {
        val toBeMapped = StackEnsembleSettingsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.stackEnsembleSettings = mapped
    }

    internal fun build(): RegressionTrainingSettingsArgs = RegressionTrainingSettingsArgs(
        allowedTrainingAlgorithms = allowedTrainingAlgorithms,
        blockedTrainingAlgorithms = blockedTrainingAlgorithms,
        enableDnnTraining = enableDnnTraining,
        enableModelExplainability = enableModelExplainability,
        enableOnnxCompatibleModels = enableOnnxCompatibleModels,
        enableStackEnsemble = enableStackEnsemble,
        enableVoteEnsemble = enableVoteEnsemble,
        ensembleModelDownloadTimeout = ensembleModelDownloadTimeout,
        stackEnsembleSettings = stackEnsembleSettings,
    )
}
