@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.machinelearningservices.kotlin.inputs

import com.pulumi.azurenative.machinelearningservices.inputs.ScriptsToExecuteArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Customized setup scripts
 * @property creationScript Script that's run only once during provision of the compute.
 * @property startupScript Script that's run every time the machine starts.
 */
public data class ScriptsToExecuteArgs(
    public val creationScript: Output<ScriptReferenceArgs>? = null,
    public val startupScript: Output<ScriptReferenceArgs>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.machinelearningservices.inputs.ScriptsToExecuteArgs> {
    override fun toJava(): com.pulumi.azurenative.machinelearningservices.inputs.ScriptsToExecuteArgs =
        com.pulumi.azurenative.machinelearningservices.inputs.ScriptsToExecuteArgs.builder()
            .creationScript(creationScript?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .startupScript(startupScript?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [ScriptsToExecuteArgs].
 */
@PulumiTagMarker
public class ScriptsToExecuteArgsBuilder internal constructor() {
    private var creationScript: Output<ScriptReferenceArgs>? = null

    private var startupScript: Output<ScriptReferenceArgs>? = null

    /**
     * @param value Script that's run only once during provision of the compute.
     */
    @JvmName("yyegdxnkkarymgyk")
    public suspend fun creationScript(`value`: Output<ScriptReferenceArgs>) {
        this.creationScript = value
    }

    /**
     * @param value Script that's run every time the machine starts.
     */
    @JvmName("goaisoftnwiijtan")
    public suspend fun startupScript(`value`: Output<ScriptReferenceArgs>) {
        this.startupScript = value
    }

    /**
     * @param value Script that's run only once during provision of the compute.
     */
    @JvmName("ktudmxhswfckvlgq")
    public suspend fun creationScript(`value`: ScriptReferenceArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.creationScript = mapped
    }

    /**
     * @param argument Script that's run only once during provision of the compute.
     */
    @JvmName("wuxkjjsojpkyfxpx")
    public suspend fun creationScript(argument: suspend ScriptReferenceArgsBuilder.() -> Unit) {
        val toBeMapped = ScriptReferenceArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.creationScript = mapped
    }

    /**
     * @param value Script that's run every time the machine starts.
     */
    @JvmName("qavbqeqgfnawiods")
    public suspend fun startupScript(`value`: ScriptReferenceArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.startupScript = mapped
    }

    /**
     * @param argument Script that's run every time the machine starts.
     */
    @JvmName("admbqylpnlapoxpb")
    public suspend fun startupScript(argument: suspend ScriptReferenceArgsBuilder.() -> Unit) {
        val toBeMapped = ScriptReferenceArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.startupScript = mapped
    }

    internal fun build(): ScriptsToExecuteArgs = ScriptsToExecuteArgs(
        creationScript = creationScript,
        startupScript = startupScript,
    )
}
