@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.machinelearningservices.kotlin.inputs

import com.pulumi.azurenative.machinelearningservices.inputs.SetupScriptsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Details of customized scripts to execute for setting up the cluster.
 * @property scripts Customized setup scripts
 */
public data class SetupScriptsArgs(
    public val scripts: Output<ScriptsToExecuteArgs>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.machinelearningservices.inputs.SetupScriptsArgs> {
    override fun toJava(): com.pulumi.azurenative.machinelearningservices.inputs.SetupScriptsArgs =
        com.pulumi.azurenative.machinelearningservices.inputs.SetupScriptsArgs.builder()
            .scripts(scripts?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [SetupScriptsArgs].
 */
@PulumiTagMarker
public class SetupScriptsArgsBuilder internal constructor() {
    private var scripts: Output<ScriptsToExecuteArgs>? = null

    /**
     * @param value Customized setup scripts
     */
    @JvmName("eivxvfxrafofxqqd")
    public suspend fun scripts(`value`: Output<ScriptsToExecuteArgs>) {
        this.scripts = value
    }

    /**
     * @param value Customized setup scripts
     */
    @JvmName("dlbnpjafkwrduhaf")
    public suspend fun scripts(`value`: ScriptsToExecuteArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.scripts = mapped
    }

    /**
     * @param argument Customized setup scripts
     */
    @JvmName("arjxitvinomelbcn")
    public suspend fun scripts(argument: suspend ScriptsToExecuteArgsBuilder.() -> Unit) {
        val toBeMapped = ScriptsToExecuteArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.scripts = mapped
    }

    internal fun build(): SetupScriptsArgs = SetupScriptsArgs(
        scripts = scripts,
    )
}
