@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.machinelearningservices.kotlin.inputs

import com.pulumi.azurenative.machinelearningservices.inputs.SharedPrivateLinkResourceArgs.builder
import com.pulumi.azurenative.machinelearningservices.kotlin.enums.PrivateEndpointServiceConnectionStatus
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property groupId The private link resource group id.
 * @property name Unique name of the private link.
 * @property privateLinkResourceId The resource id that private link links to.
 * @property requestMessage Request message.
 * @property status Indicates whether the connection has been Approved/Rejected/Removed by the owner of the service.
 */
public data class SharedPrivateLinkResourceArgs(
    public val groupId: Output<String>? = null,
    public val name: Output<String>? = null,
    public val privateLinkResourceId: Output<String>? = null,
    public val requestMessage: Output<String>? = null,
    public val status: Output<Either<String, PrivateEndpointServiceConnectionStatus>>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.machinelearningservices.inputs.SharedPrivateLinkResourceArgs> {
    override fun toJava():
        com.pulumi.azurenative.machinelearningservices.inputs.SharedPrivateLinkResourceArgs =
        com.pulumi.azurenative.machinelearningservices.inputs.SharedPrivateLinkResourceArgs.builder()
            .groupId(groupId?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .privateLinkResourceId(privateLinkResourceId?.applyValue({ args0 -> args0 }))
            .requestMessage(requestMessage?.applyValue({ args0 -> args0 }))
            .status(
                status?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            ).build()
}

/**
 * Builder for [SharedPrivateLinkResourceArgs].
 */
@PulumiTagMarker
public class SharedPrivateLinkResourceArgsBuilder internal constructor() {
    private var groupId: Output<String>? = null

    private var name: Output<String>? = null

    private var privateLinkResourceId: Output<String>? = null

    private var requestMessage: Output<String>? = null

    private var status: Output<Either<String, PrivateEndpointServiceConnectionStatus>>? = null

    /**
     * @param value The private link resource group id.
     */
    @JvmName("kentkfbqaeyuebft")
    public suspend fun groupId(`value`: Output<String>) {
        this.groupId = value
    }

    /**
     * @param value Unique name of the private link.
     */
    @JvmName("ivangrbsxcjyjarg")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value The resource id that private link links to.
     */
    @JvmName("qbxxxtcjbcrieovc")
    public suspend fun privateLinkResourceId(`value`: Output<String>) {
        this.privateLinkResourceId = value
    }

    /**
     * @param value Request message.
     */
    @JvmName("fvsbnocmmlatleth")
    public suspend fun requestMessage(`value`: Output<String>) {
        this.requestMessage = value
    }

    /**
     * @param value Indicates whether the connection has been Approved/Rejected/Removed by the owner of the service.
     */
    @JvmName("koijxnsrummntjvw")
    public suspend
    fun status(`value`: Output<Either<String, PrivateEndpointServiceConnectionStatus>>) {
        this.status = value
    }

    /**
     * @param value The private link resource group id.
     */
    @JvmName("urpmkmwfsjskoavf")
    public suspend fun groupId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.groupId = mapped
    }

    /**
     * @param value Unique name of the private link.
     */
    @JvmName("rnpqthscajajdgpb")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value The resource id that private link links to.
     */
    @JvmName("roisxshmyyiwpspy")
    public suspend fun privateLinkResourceId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.privateLinkResourceId = mapped
    }

    /**
     * @param value Request message.
     */
    @JvmName("xojmbnwvhwbdbmmd")
    public suspend fun requestMessage(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.requestMessage = mapped
    }

    /**
     * @param value Indicates whether the connection has been Approved/Rejected/Removed by the owner of the service.
     */
    @JvmName("hwptxghetuykjbsg")
    public suspend fun status(`value`: Either<String, PrivateEndpointServiceConnectionStatus>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.status = mapped
    }

    /**
     * @param value Indicates whether the connection has been Approved/Rejected/Removed by the owner of the service.
     */
    @JvmName("gfkvdiknalwldjps")
    public fun status(`value`: String) {
        val toBeMapped = Either.ofLeft<String, PrivateEndpointServiceConnectionStatus>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.status = mapped
    }

    /**
     * @param value Indicates whether the connection has been Approved/Rejected/Removed by the owner of the service.
     */
    @JvmName("cbnkxmvvrdaewvph")
    public fun status(`value`: PrivateEndpointServiceConnectionStatus) {
        val toBeMapped = Either.ofRight<String, PrivateEndpointServiceConnectionStatus>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.status = mapped
    }

    internal fun build(): SharedPrivateLinkResourceArgs = SharedPrivateLinkResourceArgs(
        groupId = groupId,
        name = name,
        privateLinkResourceId = privateLinkResourceId,
        requestMessage = requestMessage,
        status = status,
    )
}
