@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.machinelearningservices.kotlin.inputs

import com.pulumi.azurenative.machinelearningservices.inputs.SynapseSparkPropertiesArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property autoPauseProperties Auto pause properties.
 * @property autoScaleProperties Auto scale properties.
 * @property nodeCount The number of compute nodes currently assigned to the compute.
 * @property nodeSize Node size.
 * @property nodeSizeFamily Node size family.
 * @property poolName Pool name.
 * @property resourceGroup Name of the resource group in which workspace is located.
 * @property sparkVersion Spark version.
 * @property subscriptionId Azure subscription identifier.
 * @property workspaceName Name of Azure Machine Learning workspace.
 */
public data class SynapseSparkPropertiesArgs(
    public val autoPauseProperties: Output<AutoPausePropertiesArgs>? = null,
    public val autoScaleProperties: Output<AutoScalePropertiesArgs>? = null,
    public val nodeCount: Output<Int>? = null,
    public val nodeSize: Output<String>? = null,
    public val nodeSizeFamily: Output<String>? = null,
    public val poolName: Output<String>? = null,
    public val resourceGroup: Output<String>? = null,
    public val sparkVersion: Output<String>? = null,
    public val subscriptionId: Output<String>? = null,
    public val workspaceName: Output<String>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.machinelearningservices.inputs.SynapseSparkPropertiesArgs> {
    override fun toJava():
        com.pulumi.azurenative.machinelearningservices.inputs.SynapseSparkPropertiesArgs =
        com.pulumi.azurenative.machinelearningservices.inputs.SynapseSparkPropertiesArgs.builder()
            .autoPauseProperties(
                autoPauseProperties?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .autoScaleProperties(
                autoScaleProperties?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .nodeCount(nodeCount?.applyValue({ args0 -> args0 }))
            .nodeSize(nodeSize?.applyValue({ args0 -> args0 }))
            .nodeSizeFamily(nodeSizeFamily?.applyValue({ args0 -> args0 }))
            .poolName(poolName?.applyValue({ args0 -> args0 }))
            .resourceGroup(resourceGroup?.applyValue({ args0 -> args0 }))
            .sparkVersion(sparkVersion?.applyValue({ args0 -> args0 }))
            .subscriptionId(subscriptionId?.applyValue({ args0 -> args0 }))
            .workspaceName(workspaceName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [SynapseSparkPropertiesArgs].
 */
@PulumiTagMarker
public class SynapseSparkPropertiesArgsBuilder internal constructor() {
    private var autoPauseProperties: Output<AutoPausePropertiesArgs>? = null

    private var autoScaleProperties: Output<AutoScalePropertiesArgs>? = null

    private var nodeCount: Output<Int>? = null

    private var nodeSize: Output<String>? = null

    private var nodeSizeFamily: Output<String>? = null

    private var poolName: Output<String>? = null

    private var resourceGroup: Output<String>? = null

    private var sparkVersion: Output<String>? = null

    private var subscriptionId: Output<String>? = null

    private var workspaceName: Output<String>? = null

    /**
     * @param value Auto pause properties.
     */
    @JvmName("gocseqwmoyknihli")
    public suspend fun autoPauseProperties(`value`: Output<AutoPausePropertiesArgs>) {
        this.autoPauseProperties = value
    }

    /**
     * @param value Auto scale properties.
     */
    @JvmName("wmxixqosmaoekdqv")
    public suspend fun autoScaleProperties(`value`: Output<AutoScalePropertiesArgs>) {
        this.autoScaleProperties = value
    }

    /**
     * @param value The number of compute nodes currently assigned to the compute.
     */
    @JvmName("dqhachhcittdkoul")
    public suspend fun nodeCount(`value`: Output<Int>) {
        this.nodeCount = value
    }

    /**
     * @param value Node size.
     */
    @JvmName("yowhutvxwfonyggs")
    public suspend fun nodeSize(`value`: Output<String>) {
        this.nodeSize = value
    }

    /**
     * @param value Node size family.
     */
    @JvmName("ohnrmwavdiywflhb")
    public suspend fun nodeSizeFamily(`value`: Output<String>) {
        this.nodeSizeFamily = value
    }

    /**
     * @param value Pool name.
     */
    @JvmName("sfjomwajnhdyaaom")
    public suspend fun poolName(`value`: Output<String>) {
        this.poolName = value
    }

    /**
     * @param value Name of the resource group in which workspace is located.
     */
    @JvmName("wmmstgopmpkgkuxp")
    public suspend fun resourceGroup(`value`: Output<String>) {
        this.resourceGroup = value
    }

    /**
     * @param value Spark version.
     */
    @JvmName("jrkdycxceiauppcl")
    public suspend fun sparkVersion(`value`: Output<String>) {
        this.sparkVersion = value
    }

    /**
     * @param value Azure subscription identifier.
     */
    @JvmName("stucqwiprsxuuilr")
    public suspend fun subscriptionId(`value`: Output<String>) {
        this.subscriptionId = value
    }

    /**
     * @param value Name of Azure Machine Learning workspace.
     */
    @JvmName("xcxqjpmeepqkpxht")
    public suspend fun workspaceName(`value`: Output<String>) {
        this.workspaceName = value
    }

    /**
     * @param value Auto pause properties.
     */
    @JvmName("fdbhhvddntnekmia")
    public suspend fun autoPauseProperties(`value`: AutoPausePropertiesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.autoPauseProperties = mapped
    }

    /**
     * @param argument Auto pause properties.
     */
    @JvmName("rhivjepfhawyaauq")
    public suspend
    fun autoPauseProperties(argument: suspend AutoPausePropertiesArgsBuilder.() -> Unit) {
        val toBeMapped = AutoPausePropertiesArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.autoPauseProperties = mapped
    }

    /**
     * @param value Auto scale properties.
     */
    @JvmName("dmdbefhmcbsfbpkc")
    public suspend fun autoScaleProperties(`value`: AutoScalePropertiesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.autoScaleProperties = mapped
    }

    /**
     * @param argument Auto scale properties.
     */
    @JvmName("ylcfgjdhuuuhfnlf")
    public suspend
    fun autoScaleProperties(argument: suspend AutoScalePropertiesArgsBuilder.() -> Unit) {
        val toBeMapped = AutoScalePropertiesArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.autoScaleProperties = mapped
    }

    /**
     * @param value The number of compute nodes currently assigned to the compute.
     */
    @JvmName("efpphxxcalledtli")
    public suspend fun nodeCount(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.nodeCount = mapped
    }

    /**
     * @param value Node size.
     */
    @JvmName("jveayqpsmwvqgmrm")
    public suspend fun nodeSize(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.nodeSize = mapped
    }

    /**
     * @param value Node size family.
     */
    @JvmName("jlodauctgddqvxui")
    public suspend fun nodeSizeFamily(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.nodeSizeFamily = mapped
    }

    /**
     * @param value Pool name.
     */
    @JvmName("qvbwrbtkvmeosysj")
    public suspend fun poolName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.poolName = mapped
    }

    /**
     * @param value Name of the resource group in which workspace is located.
     */
    @JvmName("tpxfahfpexmidjvd")
    public suspend fun resourceGroup(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroup = mapped
    }

    /**
     * @param value Spark version.
     */
    @JvmName("iyvnsqmsooavuvej")
    public suspend fun sparkVersion(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sparkVersion = mapped
    }

    /**
     * @param value Azure subscription identifier.
     */
    @JvmName("gjxxfwsjushocmkn")
    public suspend fun subscriptionId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.subscriptionId = mapped
    }

    /**
     * @param value Name of Azure Machine Learning workspace.
     */
    @JvmName("jubjrdsicufvmotg")
    public suspend fun workspaceName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.workspaceName = mapped
    }

    internal fun build(): SynapseSparkPropertiesArgs = SynapseSparkPropertiesArgs(
        autoPauseProperties = autoPauseProperties,
        autoScaleProperties = autoScaleProperties,
        nodeCount = nodeCount,
        nodeSize = nodeSize,
        nodeSizeFamily = nodeSizeFamily,
        poolName = poolName,
        resourceGroup = resourceGroup,
        sparkVersion = sparkVersion,
        subscriptionId = subscriptionId,
        workspaceName = workspaceName,
    )
}
