@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.machinelearningservices.kotlin.inputs

import com.pulumi.azurenative.machinelearningservices.inputs.TensorFlowArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * TensorFlow distribution configuration.
 * @property distributionType Enum to determine the job distribution type.
 * Expected value is 'TensorFlow'.
 * @property parameterServerCount Number of parameter server tasks.
 * @property workerCount Number of workers. If not specified, will default to the instance count.
 */
public data class TensorFlowArgs(
    public val distributionType: Output<String>,
    public val parameterServerCount: Output<Int>? = null,
    public val workerCount: Output<Int>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.machinelearningservices.inputs.TensorFlowArgs> {
    override fun toJava(): com.pulumi.azurenative.machinelearningservices.inputs.TensorFlowArgs =
        com.pulumi.azurenative.machinelearningservices.inputs.TensorFlowArgs.builder()
            .distributionType(distributionType.applyValue({ args0 -> args0 }))
            .parameterServerCount(parameterServerCount?.applyValue({ args0 -> args0 }))
            .workerCount(workerCount?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [TensorFlowArgs].
 */
@PulumiTagMarker
public class TensorFlowArgsBuilder internal constructor() {
    private var distributionType: Output<String>? = null

    private var parameterServerCount: Output<Int>? = null

    private var workerCount: Output<Int>? = null

    /**
     * @param value Enum to determine the job distribution type.
     * Expected value is 'TensorFlow'.
     */
    @JvmName("tdnjtjlhusuvfsti")
    public suspend fun distributionType(`value`: Output<String>) {
        this.distributionType = value
    }

    /**
     * @param value Number of parameter server tasks.
     */
    @JvmName("cpsdicmtiydvhqbf")
    public suspend fun parameterServerCount(`value`: Output<Int>) {
        this.parameterServerCount = value
    }

    /**
     * @param value Number of workers. If not specified, will default to the instance count.
     */
    @JvmName("pfdxjhxumkwecphv")
    public suspend fun workerCount(`value`: Output<Int>) {
        this.workerCount = value
    }

    /**
     * @param value Enum to determine the job distribution type.
     * Expected value is 'TensorFlow'.
     */
    @JvmName("kcumlfvivgtgjsve")
    public suspend fun distributionType(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.distributionType = mapped
    }

    /**
     * @param value Number of parameter server tasks.
     */
    @JvmName("yyjblotubbvgqswr")
    public suspend fun parameterServerCount(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.parameterServerCount = mapped
    }

    /**
     * @param value Number of workers. If not specified, will default to the instance count.
     */
    @JvmName("uygkwmfabttbkiik")
    public suspend fun workerCount(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.workerCount = mapped
    }

    internal fun build(): TensorFlowArgs = TensorFlowArgs(
        distributionType = distributionType ?: throw PulumiNullFieldException("distributionType"),
        parameterServerCount = parameterServerCount,
        workerCount = workerCount,
    )
}
