@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.machinelearningservices.kotlin.inputs

import com.pulumi.azurenative.machinelearningservices.inputs.TrialComponentArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Any
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Trial component definition.
 * @property codeId ARM resource ID of the code asset.
 * @property command [Required] The command to execute on startup of the job. eg. "python train.py"
 * @property distribution Distribution configuration of the job. If set, this should be one of Mpi, Tensorflow, PyTorch, or null.
 * @property environmentId [Required] The ARM resource ID of the Environment specification for the job.
 * @property environmentVariables Environment variables included in the job.
 * @property resources Compute Resource configuration for the job.
 */
public data class TrialComponentArgs(
    public val codeId: Output<String>? = null,
    public val command: Output<String>,
    public val distribution: Output<Any>? = null,
    public val environmentId: Output<String>,
    public val environmentVariables: Output<Map<String, String>>? = null,
    public val resources: Output<JobResourceConfigurationArgs>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.machinelearningservices.inputs.TrialComponentArgs> {
    override fun toJava(): com.pulumi.azurenative.machinelearningservices.inputs.TrialComponentArgs =
        com.pulumi.azurenative.machinelearningservices.inputs.TrialComponentArgs.builder()
            .codeId(codeId?.applyValue({ args0 -> args0 }))
            .command(command.applyValue({ args0 -> args0 }))
            .distribution(distribution?.applyValue({ args0 -> args0 }))
            .environmentId(environmentId.applyValue({ args0 -> args0 }))
            .environmentVariables(
                environmentVariables?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            )
            .resources(resources?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [TrialComponentArgs].
 */
@PulumiTagMarker
public class TrialComponentArgsBuilder internal constructor() {
    private var codeId: Output<String>? = null

    private var command: Output<String>? = null

    private var distribution: Output<Any>? = null

    private var environmentId: Output<String>? = null

    private var environmentVariables: Output<Map<String, String>>? = null

    private var resources: Output<JobResourceConfigurationArgs>? = null

    /**
     * @param value ARM resource ID of the code asset.
     */
    @JvmName("ejtvglsxinmdygqd")
    public suspend fun codeId(`value`: Output<String>) {
        this.codeId = value
    }

    /**
     * @param value [Required] The command to execute on startup of the job. eg. "python train.py"
     */
    @JvmName("qyllgvtmugctjoao")
    public suspend fun command(`value`: Output<String>) {
        this.command = value
    }

    /**
     * @param value Distribution configuration of the job. If set, this should be one of Mpi, Tensorflow, PyTorch, or null.
     */
    @JvmName("bgsqbwspllabhjii")
    public suspend fun distribution(`value`: Output<Any>) {
        this.distribution = value
    }

    /**
     * @param value [Required] The ARM resource ID of the Environment specification for the job.
     */
    @JvmName("wdsgywnwqxvpxhrq")
    public suspend fun environmentId(`value`: Output<String>) {
        this.environmentId = value
    }

    /**
     * @param value Environment variables included in the job.
     */
    @JvmName("oggjqpckyxttswny")
    public suspend fun environmentVariables(`value`: Output<Map<String, String>>) {
        this.environmentVariables = value
    }

    /**
     * @param value Compute Resource configuration for the job.
     */
    @JvmName("kkfjmdpretjftgob")
    public suspend fun resources(`value`: Output<JobResourceConfigurationArgs>) {
        this.resources = value
    }

    /**
     * @param value ARM resource ID of the code asset.
     */
    @JvmName("mlrsbvdnljuowhrj")
    public suspend fun codeId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.codeId = mapped
    }

    /**
     * @param value [Required] The command to execute on startup of the job. eg. "python train.py"
     */
    @JvmName("kovuyjvgjoborctf")
    public suspend fun command(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.command = mapped
    }

    /**
     * @param value Distribution configuration of the job. If set, this should be one of Mpi, Tensorflow, PyTorch, or null.
     */
    @JvmName("grnbirsbsqlfkudu")
    public suspend fun distribution(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.distribution = mapped
    }

    /**
     * @param value [Required] The ARM resource ID of the Environment specification for the job.
     */
    @JvmName("rjwymqelqwodqpaj")
    public suspend fun environmentId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.environmentId = mapped
    }

    /**
     * @param value Environment variables included in the job.
     */
    @JvmName("fqghmqblwgfvabdw")
    public suspend fun environmentVariables(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.environmentVariables = mapped
    }

    /**
     * @param values Environment variables included in the job.
     */
    @JvmName("bvkllpywrwouvnmb")
    public fun environmentVariables(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.environmentVariables = mapped
    }

    /**
     * @param value Compute Resource configuration for the job.
     */
    @JvmName("ackmtmsjfpsqxxbk")
    public suspend fun resources(`value`: JobResourceConfigurationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resources = mapped
    }

    /**
     * @param argument Compute Resource configuration for the job.
     */
    @JvmName("kelpdpgovkqphypd")
    public suspend fun resources(argument: suspend JobResourceConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped = JobResourceConfigurationArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.resources = mapped
    }

    internal fun build(): TrialComponentArgs = TrialComponentArgs(
        codeId = codeId,
        command = command ?: throw PulumiNullFieldException("command"),
        distribution = distribution,
        environmentId = environmentId ?: throw PulumiNullFieldException("environmentId"),
        environmentVariables = environmentVariables,
        resources = resources,
    )
}
