@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.machinelearningservices.kotlin.inputs

import com.pulumi.azurenative.machinelearningservices.inputs.UriFileDataVersionArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * uri-file data version entity
 * @property dataType Enum to determine the type of data.
 * Expected value is 'uri_file'.
 * @property dataUri [Required] Uri of the data. Example: https://go.microsoft.com/fwlink/?linkid=2202330
 * @property description The asset description text.
 * @property isAnonymous If the name version are system generated (anonymous registration).
 * @property isArchived Is the asset archived?
 * @property properties The asset property dictionary.
 * @property tags Tag dictionary. Tags can be added, removed, and updated.
 */
public data class UriFileDataVersionArgs(
    public val dataType: Output<String>,
    public val dataUri: Output<String>,
    public val description: Output<String>? = null,
    public val isAnonymous: Output<Boolean>? = null,
    public val isArchived: Output<Boolean>? = null,
    public val properties: Output<Map<String, String>>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.machinelearningservices.inputs.UriFileDataVersionArgs> {
    override fun toJava():
        com.pulumi.azurenative.machinelearningservices.inputs.UriFileDataVersionArgs =
        com.pulumi.azurenative.machinelearningservices.inputs.UriFileDataVersionArgs.builder()
            .dataType(dataType.applyValue({ args0 -> args0 }))
            .dataUri(dataUri.applyValue({ args0 -> args0 }))
            .description(description?.applyValue({ args0 -> args0 }))
            .isAnonymous(isAnonymous?.applyValue({ args0 -> args0 }))
            .isArchived(isArchived?.applyValue({ args0 -> args0 }))
            .properties(
                properties?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            )
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [UriFileDataVersionArgs].
 */
@PulumiTagMarker
public class UriFileDataVersionArgsBuilder internal constructor() {
    private var dataType: Output<String>? = null

    private var dataUri: Output<String>? = null

    private var description: Output<String>? = null

    private var isAnonymous: Output<Boolean>? = null

    private var isArchived: Output<Boolean>? = null

    private var properties: Output<Map<String, String>>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value Enum to determine the type of data.
     * Expected value is 'uri_file'.
     */
    @JvmName("eusiyebyffeiwncy")
    public suspend fun dataType(`value`: Output<String>) {
        this.dataType = value
    }

    /**
     * @param value [Required] Uri of the data. Example: https://go.microsoft.com/fwlink/?linkid=2202330
     */
    @JvmName("mnmmyrcieuuyqshw")
    public suspend fun dataUri(`value`: Output<String>) {
        this.dataUri = value
    }

    /**
     * @param value The asset description text.
     */
    @JvmName("jyhmfmwpivxdojfd")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value If the name version are system generated (anonymous registration).
     */
    @JvmName("tdbiiinnqodsqjgy")
    public suspend fun isAnonymous(`value`: Output<Boolean>) {
        this.isAnonymous = value
    }

    /**
     * @param value Is the asset archived?
     */
    @JvmName("dwtkyyjafvkhmjuj")
    public suspend fun isArchived(`value`: Output<Boolean>) {
        this.isArchived = value
    }

    /**
     * @param value The asset property dictionary.
     */
    @JvmName("bbdkqrgcdefswvtt")
    public suspend fun properties(`value`: Output<Map<String, String>>) {
        this.properties = value
    }

    /**
     * @param value Tag dictionary. Tags can be added, removed, and updated.
     */
    @JvmName("elxrkysorrfhavvo")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value Enum to determine the type of data.
     * Expected value is 'uri_file'.
     */
    @JvmName("iimwychlmuxipjad")
    public suspend fun dataType(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.dataType = mapped
    }

    /**
     * @param value [Required] Uri of the data. Example: https://go.microsoft.com/fwlink/?linkid=2202330
     */
    @JvmName("vgnpaiypnvhhaikh")
    public suspend fun dataUri(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.dataUri = mapped
    }

    /**
     * @param value The asset description text.
     */
    @JvmName("dgmnbxorwvjoejdh")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value If the name version are system generated (anonymous registration).
     */
    @JvmName("nqnmwdmonvsmqvqp")
    public suspend fun isAnonymous(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.isAnonymous = mapped
    }

    /**
     * @param value Is the asset archived?
     */
    @JvmName("dgowawscswgdwgrg")
    public suspend fun isArchived(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.isArchived = mapped
    }

    /**
     * @param value The asset property dictionary.
     */
    @JvmName("kajsssmpbgsquoao")
    public suspend fun properties(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.properties = mapped
    }

    /**
     * @param values The asset property dictionary.
     */
    @JvmName("hkrkkcmsuwtsqfgl")
    public fun properties(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.properties = mapped
    }

    /**
     * @param value Tag dictionary. Tags can be added, removed, and updated.
     */
    @JvmName("cyqmbcndqyhihiai")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Tag dictionary. Tags can be added, removed, and updated.
     */
    @JvmName("ryeoaxdpaxgdqkub")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): UriFileDataVersionArgs = UriFileDataVersionArgs(
        dataType = dataType ?: throw PulumiNullFieldException("dataType"),
        dataUri = dataUri ?: throw PulumiNullFieldException("dataUri"),
        description = description,
        isAnonymous = isAnonymous,
        isArchived = isArchived,
        properties = properties,
        tags = tags,
    )
}
