@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.machinelearningservices.kotlin.inputs

import com.pulumi.azurenative.machinelearningservices.inputs.UriFolderDataVersionArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * uri-folder data version entity
 * @property dataType Enum to determine the type of data.
 * Expected value is 'uri_folder'.
 * @property dataUri [Required] Uri of the data. Example: https://go.microsoft.com/fwlink/?linkid=2202330
 * @property description The asset description text.
 * @property isAnonymous If the name version are system generated (anonymous registration).
 * @property isArchived Is the asset archived?
 * @property properties The asset property dictionary.
 * @property tags Tag dictionary. Tags can be added, removed, and updated.
 */
public data class UriFolderDataVersionArgs(
    public val dataType: Output<String>,
    public val dataUri: Output<String>,
    public val description: Output<String>? = null,
    public val isAnonymous: Output<Boolean>? = null,
    public val isArchived: Output<Boolean>? = null,
    public val properties: Output<Map<String, String>>? = null,
    public val tags: Output<Map<String, String>>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.machinelearningservices.inputs.UriFolderDataVersionArgs> {
    override fun toJava():
        com.pulumi.azurenative.machinelearningservices.inputs.UriFolderDataVersionArgs =
        com.pulumi.azurenative.machinelearningservices.inputs.UriFolderDataVersionArgs.builder()
            .dataType(dataType.applyValue({ args0 -> args0 }))
            .dataUri(dataUri.applyValue({ args0 -> args0 }))
            .description(description?.applyValue({ args0 -> args0 }))
            .isAnonymous(isAnonymous?.applyValue({ args0 -> args0 }))
            .isArchived(isArchived?.applyValue({ args0 -> args0 }))
            .properties(
                properties?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            )
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [UriFolderDataVersionArgs].
 */
@PulumiTagMarker
public class UriFolderDataVersionArgsBuilder internal constructor() {
    private var dataType: Output<String>? = null

    private var dataUri: Output<String>? = null

    private var description: Output<String>? = null

    private var isAnonymous: Output<Boolean>? = null

    private var isArchived: Output<Boolean>? = null

    private var properties: Output<Map<String, String>>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value Enum to determine the type of data.
     * Expected value is 'uri_folder'.
     */
    @JvmName("cahceqrkdfwbfaoa")
    public suspend fun dataType(`value`: Output<String>) {
        this.dataType = value
    }

    /**
     * @param value [Required] Uri of the data. Example: https://go.microsoft.com/fwlink/?linkid=2202330
     */
    @JvmName("fgelcuwheshaeyjj")
    public suspend fun dataUri(`value`: Output<String>) {
        this.dataUri = value
    }

    /**
     * @param value The asset description text.
     */
    @JvmName("vbpyhuvyqyaksbxp")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value If the name version are system generated (anonymous registration).
     */
    @JvmName("cldlqnqyrfnamhgh")
    public suspend fun isAnonymous(`value`: Output<Boolean>) {
        this.isAnonymous = value
    }

    /**
     * @param value Is the asset archived?
     */
    @JvmName("sbalnjfhouhijeuc")
    public suspend fun isArchived(`value`: Output<Boolean>) {
        this.isArchived = value
    }

    /**
     * @param value The asset property dictionary.
     */
    @JvmName("bkgugjmdefncbvuo")
    public suspend fun properties(`value`: Output<Map<String, String>>) {
        this.properties = value
    }

    /**
     * @param value Tag dictionary. Tags can be added, removed, and updated.
     */
    @JvmName("ansqloxyrdatkxfi")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value Enum to determine the type of data.
     * Expected value is 'uri_folder'.
     */
    @JvmName("svdcqqtiucpgumue")
    public suspend fun dataType(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.dataType = mapped
    }

    /**
     * @param value [Required] Uri of the data. Example: https://go.microsoft.com/fwlink/?linkid=2202330
     */
    @JvmName("omnxdufiirvlnrpk")
    public suspend fun dataUri(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.dataUri = mapped
    }

    /**
     * @param value The asset description text.
     */
    @JvmName("ujuijaddrucptxym")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value If the name version are system generated (anonymous registration).
     */
    @JvmName("qtlaivydjihrfcre")
    public suspend fun isAnonymous(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.isAnonymous = mapped
    }

    /**
     * @param value Is the asset archived?
     */
    @JvmName("vgjdfwyvviviyjoy")
    public suspend fun isArchived(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.isArchived = mapped
    }

    /**
     * @param value The asset property dictionary.
     */
    @JvmName("onuxifasksttebjv")
    public suspend fun properties(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.properties = mapped
    }

    /**
     * @param values The asset property dictionary.
     */
    @JvmName("thmqndnvcbmedaai")
    public fun properties(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.properties = mapped
    }

    /**
     * @param value Tag dictionary. Tags can be added, removed, and updated.
     */
    @JvmName("dneotxgyrswnosxm")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Tag dictionary. Tags can be added, removed, and updated.
     */
    @JvmName("ddyruvtesfwsanhc")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): UriFolderDataVersionArgs = UriFolderDataVersionArgs(
        dataType = dataType ?: throw PulumiNullFieldException("dataType"),
        dataUri = dataUri ?: throw PulumiNullFieldException("dataUri"),
        description = description,
        isAnonymous = isAnonymous,
        isArchived = isArchived,
        properties = properties,
        tags = tags,
    )
}
