@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.machinelearningservices.kotlin.inputs

import com.pulumi.azurenative.machinelearningservices.inputs.WorkspaceConnectionUsernamePasswordArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property password
 * @property username
 */
public data class WorkspaceConnectionUsernamePasswordArgs(
    public val password: Output<String>? = null,
    public val username: Output<String>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.machinelearningservices.inputs.WorkspaceConnectionUsernamePasswordArgs> {
    override fun toJava():
        com.pulumi.azurenative.machinelearningservices.inputs.WorkspaceConnectionUsernamePasswordArgs =
        com.pulumi.azurenative.machinelearningservices.inputs.WorkspaceConnectionUsernamePasswordArgs.builder()
            .password(password?.applyValue({ args0 -> args0 }))
            .username(username?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [WorkspaceConnectionUsernamePasswordArgs].
 */
@PulumiTagMarker
public class WorkspaceConnectionUsernamePasswordArgsBuilder internal constructor() {
    private var password: Output<String>? = null

    private var username: Output<String>? = null

    /**
     * @param value
     */
    @JvmName("xojiscytxtnirgwe")
    public suspend fun password(`value`: Output<String>) {
        this.password = value
    }

    /**
     * @param value
     */
    @JvmName("lphwpcvkcuxlgehg")
    public suspend fun username(`value`: Output<String>) {
        this.username = value
    }

    /**
     * @param value
     */
    @JvmName("mlplvprqglntittr")
    public suspend fun password(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.password = mapped
    }

    /**
     * @param value
     */
    @JvmName("wohyajtgooyyigmu")
    public suspend fun username(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.username = mapped
    }

    internal fun build(): WorkspaceConnectionUsernamePasswordArgs =
        WorkspaceConnectionUsernamePasswordArgs(
            password = password,
            username = username,
        )
}
