@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.machinelearningservices.kotlin.outputs

import kotlin.Any
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Defines an Aml Instance container.
 * @property autosave Auto save settings.
 * @property environment Environment information of this container.
 * @property gpu Information of GPU.
 * @property name Name of the ComputeInstance container.
 * @property network network of this container.
 * @property services services of this containers.
 */
public data class ComputeInstanceContainerResponse(
    public val autosave: String? = null,
    public val environment: ComputeInstanceEnvironmentInfoResponse? = null,
    public val gpu: String? = null,
    public val name: String? = null,
    public val network: String? = null,
    public val services: List<Any>,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.machinelearningservices.outputs.ComputeInstanceContainerResponse):
            ComputeInstanceContainerResponse = ComputeInstanceContainerResponse(
            autosave = javaType.autosave().map({ args0 -> args0 }).orElse(null),
            environment = javaType.environment().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.machinelearningservices.kotlin.outputs.ComputeInstanceEnvironmentInfoResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            gpu = javaType.gpu().map({ args0 -> args0 }).orElse(null),
            name = javaType.name().map({ args0 -> args0 }).orElse(null),
            network = javaType.network().map({ args0 -> args0 }).orElse(null),
            services = javaType.services().map({ args0 -> args0 }),
        )
    }
}
