@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.machinelearningservices.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Describes information on user who created this ComputeInstance.
 * @property userId Uniquely identifies the user within his/her organization.
 * @property userName Name of the user.
 * @property userOrgId Uniquely identifies user' Azure Active Directory organization.
 */
public data class ComputeInstanceCreatedByResponse(
    public val userId: String,
    public val userName: String,
    public val userOrgId: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.machinelearningservices.outputs.ComputeInstanceCreatedByResponse):
            ComputeInstanceCreatedByResponse = ComputeInstanceCreatedByResponse(
            userId = javaType.userId(),
            userName = javaType.userName(),
            userOrgId = javaType.userOrgId(),
        )
    }
}
