@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.machinelearningservices.kotlin.outputs

import kotlin.Suppress

/**
 * Resource requirements for each container instance within an online deployment.
 * @property containerResourceLimits Container resource limit info:
 * @property containerResourceRequests Container resource request info:
 */
public data class ContainerResourceRequirementsResponse(
    public val containerResourceLimits: ContainerResourceSettingsResponse? = null,
    public val containerResourceRequests: ContainerResourceSettingsResponse? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.machinelearningservices.outputs.ContainerResourceRequirementsResponse):
            ContainerResourceRequirementsResponse = ContainerResourceRequirementsResponse(
            containerResourceLimits = javaType.containerResourceLimits().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.machinelearningservices.kotlin.outputs.ContainerResourceSettingsResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            containerResourceRequests = javaType.containerResourceRequests().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.machinelearningservices.kotlin.outputs.ContainerResourceSettingsResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
        )
    }
}
