@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.machinelearningservices.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property endTime Specifies end time of schedule in ISO 8601, but without a UTC offset. Refer https://en.wikipedia.org/wiki/ISO_8601.
 * Recommented format would be "2022-06-01T00:00:01"
 * If not present, the schedule will run indefinitely
 * @property expression [Required] Specifies cron expression of schedule.
 * The expression should follow NCronTab format.
 * @property startTime Specifies start time of schedule in ISO 8601 format, but without a UTC offset.
 * @property timeZone Specifies time zone in which the schedule runs.
 * TimeZone should follow Windows time zone format. Refer: https://docs.microsoft.com/en-us/windows-hardware/manufacture/desktop/default-time-zones?view=windows-11
 * @property triggerType
 * Expected value is 'Cron'.
 */
public data class CronTriggerResponse(
    public val endTime: String? = null,
    public val expression: String,
    public val startTime: String? = null,
    public val timeZone: String? = null,
    public val triggerType: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.machinelearningservices.outputs.CronTriggerResponse):
            CronTriggerResponse = CronTriggerResponse(
            endTime = javaType.endTime().map({ args0 -> args0 }).orElse(null),
            expression = javaType.expression(),
            startTime = javaType.startTime().map({ args0 -> args0 }).orElse(null),
            timeZone = javaType.timeZone().map({ args0 -> args0 }).orElse(null),
            triggerType = javaType.triggerType(),
        )
    }
}
