@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.machinelearningservices.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map

/**
 * Machine Learning dataset object.
 * @property createdTime The dataset creation time (UTC).
 * @property datasetId Unique Dataset identifier.
 * @property datasetState Dataset state
 * @property datasetType Dataset Type.
 * @property defaultCompute Name of the default compute to be used for any Dataset actions (such as Profile, Write).
 * @property description Description about this dataset version.
 * @property etag eTag description
 * @property isVisible Flag to hide Dataset in UI
 * @property latest Last created Dataset definition.
 * @property modifiedTime The dataset last modified time (UTC).
 * @property name Unique dataset name
 * @property tags Tags for this dataset version.
 */
public data class DatasetResponse(
    public val createdTime: String,
    public val datasetId: String,
    public val datasetState: DatasetStateResponse? = null,
    public val datasetType: String,
    public val defaultCompute: String,
    public val description: String,
    public val etag: String,
    public val isVisible: Boolean,
    public val latest: DatasetResponseLatest? = null,
    public val modifiedTime: String,
    public val name: String,
    public val tags: Map<String, String>,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.machinelearningservices.outputs.DatasetResponse):
            DatasetResponse = DatasetResponse(
            createdTime = javaType.createdTime(),
            datasetId = javaType.datasetId(),
            datasetState = javaType.datasetState().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.machinelearningservices.kotlin.outputs.DatasetStateResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            datasetType = javaType.datasetType(),
            defaultCompute = javaType.defaultCompute(),
            description = javaType.description(),
            etag = javaType.etag(),
            isVisible = javaType.isVisible(),
            latest = javaType.latest().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.machinelearningservices.kotlin.outputs.DatasetResponseLatest.Companion.toKotlin(args0)
                })
            }).orElse(null),
            modifiedTime = javaType.modifiedTime(),
            name = javaType.name(),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
        )
    }
}
