@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.machinelearningservices.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map

/**
 * Dto object representing the feature set job
 * @property createdDate Specifies the created date
 * @property displayName Specifies the display name
 * @property duration Specifies the duration
 * @property experimentId Specifies the experiment id
 * @property featureWindow Specifies the backfill feature window to be materialized
 * @property jobId Specifies the job id
 * @property status Specifies the job status
 * @property tags Specifies the tags if any
 * @property type Specifies the feature store job type
 */
public data class FeaturesetJobResponse(
    public val createdDate: String? = null,
    public val displayName: String? = null,
    public val duration: String? = null,
    public val experimentId: String? = null,
    public val featureWindow: FeatureWindowResponse? = null,
    public val jobId: String? = null,
    public val status: String? = null,
    public val tags: Map<String, String>? = null,
    public val type: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.machinelearningservices.outputs.FeaturesetJobResponse):
            FeaturesetJobResponse = FeaturesetJobResponse(
            createdDate = javaType.createdDate().map({ args0 -> args0 }).orElse(null),
            displayName = javaType.displayName().map({ args0 -> args0 }).orElse(null),
            duration = javaType.duration().map({ args0 -> args0 }).orElse(null),
            experimentId = javaType.experimentId().map({ args0 -> args0 }).orElse(null),
            featureWindow = javaType.featureWindow().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.machinelearningservices.kotlin.outputs.FeatureWindowResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            jobId = javaType.jobId().map({ args0 -> args0 }).orElse(null),
            status = javaType.status().map({ args0 -> args0 }).orElse(null),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            type = javaType.type().map({ args0 -> args0 }).orElse(null),
        )
    }
}
