@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.machinelearningservices.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Forecasting Training related configuration.
 * @property allowedTrainingAlgorithms Allowed models for forecasting task.
 * @property blockedTrainingAlgorithms Blocked models for forecasting task.
 * @property enableDnnTraining Enable recommendation of DNN models.
 * @property enableModelExplainability Flag to turn on explainability on best model.
 * @property enableOnnxCompatibleModels Flag for enabling onnx compatible models.
 * @property enableStackEnsemble Enable stack ensemble run.
 * @property enableVoteEnsemble Enable voting ensemble run.
 * @property ensembleModelDownloadTimeout During VotingEnsemble and StackEnsemble model generation, multiple fitted models from the previous child runs are downloaded.
 * Configure this parameter with a higher value than 300 secs, if more time is needed.
 * @property stackEnsembleSettings Stack ensemble settings for stack ensemble run.
 */
public data class ForecastingTrainingSettingsResponse(
    public val allowedTrainingAlgorithms: List<String>? = null,
    public val blockedTrainingAlgorithms: List<String>? = null,
    public val enableDnnTraining: Boolean? = null,
    public val enableModelExplainability: Boolean? = null,
    public val enableOnnxCompatibleModels: Boolean? = null,
    public val enableStackEnsemble: Boolean? = null,
    public val enableVoteEnsemble: Boolean? = null,
    public val ensembleModelDownloadTimeout: String? = null,
    public val stackEnsembleSettings: StackEnsembleSettingsResponse? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.machinelearningservices.outputs.ForecastingTrainingSettingsResponse):
            ForecastingTrainingSettingsResponse = ForecastingTrainingSettingsResponse(
            allowedTrainingAlgorithms = javaType.allowedTrainingAlgorithms().map({ args0 -> args0 }),
            blockedTrainingAlgorithms = javaType.blockedTrainingAlgorithms().map({ args0 -> args0 }),
            enableDnnTraining = javaType.enableDnnTraining().map({ args0 -> args0 }).orElse(null),
            enableModelExplainability = javaType.enableModelExplainability().map({ args0 ->
                args0
            }).orElse(null),
            enableOnnxCompatibleModels = javaType.enableOnnxCompatibleModels().map({ args0 ->
                args0
            }).orElse(null),
            enableStackEnsemble = javaType.enableStackEnsemble().map({ args0 -> args0 }).orElse(null),
            enableVoteEnsemble = javaType.enableVoteEnsemble().map({ args0 -> args0 }).orElse(null),
            ensembleModelDownloadTimeout = javaType.ensembleModelDownloadTimeout().map({ args0 ->
                args0
            }).orElse(null),
            stackEnsembleSettings = javaType.stackEnsembleSettings().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.machinelearningservices.kotlin.outputs.StackEnsembleSettingsResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
        )
    }
}
