@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.machinelearningservices.kotlin.outputs

import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 * An object that represents a machine learning workspace.
 * @property allowPublicAccessWhenBehindVnet The flag to indicate whether to allow public access when behind VNet.
 * @property applicationInsights ARM id of the application insights associated with this workspace.
 * @property containerRegistry ARM id of the container registry associated with this workspace.
 * @property description The description of this workspace.
 * @property discoveryUrl Url for the discovery service to identify regional endpoints for machine learning experimentation services
 * @property encryption The encryption settings of Azure ML workspace.
 * @property friendlyName The friendly name for this workspace. This name in mutable
 * @property hbiWorkspace The flag to signal HBI data in the workspace and reduce diagnostic data collected by the service
 * @property id Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
 * @property identity The identity of the resource.
 * @property imageBuildCompute The compute name for image build
 * @property keyVault ARM id of the key vault associated with this workspace. This cannot be changed once the workspace has been created
 * @property location Specifies the location of the resource.
 * @property mlFlowTrackingUri The URI associated with this workspace that machine learning flow must point at to set up tracking.
 * @property name The name of the resource
 * @property notebookInfo The notebook info of Azure ML workspace.
 * @property primaryUserAssignedIdentity The user assigned identity resource id that represents the workspace identity.
 * @property privateEndpointConnections The list of private endpoint connections in the workspace.
 * @property privateLinkCount Count of private connections in the workspace
 * @property provisioningState The current deployment state of workspace resource. The provisioningState is to indicate states for resource provisioning.
 * @property publicNetworkAccess Whether requests from Public Network are allowed.
 * @property serviceManagedResourcesSettings The service managed resource settings.
 * @property serviceProvisionedResourceGroup The name of the managed resource group created by workspace RP in customer subscription if the workspace is CMK workspace
 * @property sharedPrivateLinkResources The list of shared private link resources in this workspace.
 * @property sku The sku of the workspace.
 * @property storageAccount ARM id of the storage account associated with this workspace. This cannot be changed once the workspace has been created
 * @property storageHnsEnabled If the storage associated with the workspace has hierarchical namespace(HNS) enabled.
 * @property systemData Azure Resource Manager metadata containing createdBy and modifiedBy information.
 * @property tags Contains resource tags defined as key/value pairs.
 * @property tenantId The tenant id associated with this workspace.
 * @property type The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
 * @property v1LegacyMode Enabling v1_legacy_mode may prevent you from using features provided by the v2 API.
 * @property workspaceId The immutable id associated with this workspace.
 */
public data class GetWorkspaceResult(
    public val allowPublicAccessWhenBehindVnet: Boolean? = null,
    public val applicationInsights: String? = null,
    public val containerRegistry: String? = null,
    public val description: String? = null,
    public val discoveryUrl: String? = null,
    public val encryption: EncryptionPropertyResponse? = null,
    public val friendlyName: String? = null,
    public val hbiWorkspace: Boolean? = null,
    public val id: String,
    public val identity: ManagedServiceIdentityResponse? = null,
    public val imageBuildCompute: String? = null,
    public val keyVault: String? = null,
    public val location: String? = null,
    public val mlFlowTrackingUri: String,
    public val name: String,
    public val notebookInfo: NotebookResourceInfoResponse,
    public val primaryUserAssignedIdentity: String? = null,
    public val privateEndpointConnections: List<PrivateEndpointConnectionResponse>,
    public val privateLinkCount: Int,
    public val provisioningState: String,
    public val publicNetworkAccess: String? = null,
    public val serviceManagedResourcesSettings: ServiceManagedResourcesSettingsResponse? = null,
    public val serviceProvisionedResourceGroup: String,
    public val sharedPrivateLinkResources: List<SharedPrivateLinkResourceResponse>? = null,
    public val sku: SkuResponse? = null,
    public val storageAccount: String? = null,
    public val storageHnsEnabled: Boolean,
    public val systemData: SystemDataResponse,
    public val tags: Map<String, String>? = null,
    public val tenantId: String,
    public val type: String,
    public val v1LegacyMode: Boolean? = null,
    public val workspaceId: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.machinelearningservices.outputs.GetWorkspaceResult):
            GetWorkspaceResult = GetWorkspaceResult(
            allowPublicAccessWhenBehindVnet = javaType.allowPublicAccessWhenBehindVnet().map({ args0 ->
                args0
            }).orElse(null),
            applicationInsights = javaType.applicationInsights().map({ args0 -> args0 }).orElse(null),
            containerRegistry = javaType.containerRegistry().map({ args0 -> args0 }).orElse(null),
            description = javaType.description().map({ args0 -> args0 }).orElse(null),
            discoveryUrl = javaType.discoveryUrl().map({ args0 -> args0 }).orElse(null),
            encryption = javaType.encryption().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.machinelearningservices.kotlin.outputs.EncryptionPropertyResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            friendlyName = javaType.friendlyName().map({ args0 -> args0 }).orElse(null),
            hbiWorkspace = javaType.hbiWorkspace().map({ args0 -> args0 }).orElse(null),
            id = javaType.id(),
            identity = javaType.identity().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.machinelearningservices.kotlin.outputs.ManagedServiceIdentityResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            imageBuildCompute = javaType.imageBuildCompute().map({ args0 -> args0 }).orElse(null),
            keyVault = javaType.keyVault().map({ args0 -> args0 }).orElse(null),
            location = javaType.location().map({ args0 -> args0 }).orElse(null),
            mlFlowTrackingUri = javaType.mlFlowTrackingUri(),
            name = javaType.name(),
            notebookInfo = javaType.notebookInfo().let({ args0 ->
                com.pulumi.azurenative.machinelearningservices.kotlin.outputs.NotebookResourceInfoResponse.Companion.toKotlin(args0)
            }),
            primaryUserAssignedIdentity = javaType.primaryUserAssignedIdentity().map({ args0 ->
                args0
            }).orElse(null),
            privateEndpointConnections = javaType.privateEndpointConnections().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.machinelearningservices.kotlin.outputs.PrivateEndpointConnectionResponse.Companion.toKotlin(args0)
                })
            }),
            privateLinkCount = javaType.privateLinkCount(),
            provisioningState = javaType.provisioningState(),
            publicNetworkAccess = javaType.publicNetworkAccess().map({ args0 -> args0 }).orElse(null),
            serviceManagedResourcesSettings = javaType.serviceManagedResourcesSettings().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.machinelearningservices.kotlin.outputs.ServiceManagedResourcesSettingsResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            serviceProvisionedResourceGroup = javaType.serviceProvisionedResourceGroup(),
            sharedPrivateLinkResources = javaType.sharedPrivateLinkResources().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.machinelearningservices.kotlin.outputs.SharedPrivateLinkResourceResponse.Companion.toKotlin(args0)
                })
            }),
            sku = javaType.sku().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.machinelearningservices.kotlin.outputs.SkuResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            storageAccount = javaType.storageAccount().map({ args0 -> args0 }).orElse(null),
            storageHnsEnabled = javaType.storageHnsEnabled(),
            systemData = javaType.systemData().let({ args0 ->
                com.pulumi.azurenative.machinelearningservices.kotlin.outputs.SystemDataResponse.Companion.toKotlin(args0)
            }),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            tenantId = javaType.tenantId(),
            type = javaType.type(),
            v1LegacyMode = javaType.v1LegacyMode().map({ args0 -> args0 }).orElse(null),
            workspaceId = javaType.workspaceId(),
        )
    }
}
