@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.machinelearningservices.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Data specific to GlusterFS.
 * @property serverAddress The server address of one of the servers that hosts the GlusterFS. Can be either the IP address or server name.
 * @property volumeName The name of the created GlusterFS volume.
 */
public data class GlusterFsSectionResponse(
    public val serverAddress: String,
    public val volumeName: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.machinelearningservices.outputs.GlusterFsSectionResponse):
            GlusterFsSectionResponse = GlusterFsSectionResponse(
            serverAddress = javaType.serverAddress(),
            volumeName = javaType.volumeName(),
        )
    }
}
